package com.bcxin.survey.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import com.bcxin.survey.vo.DwzPage;

import net.sf.json.JSONObject;

public class DWZUtil {
	
	/**
	 * 返回 dwz 格式的json串（失败）
	 * 
	 * @param message
	 *            界面提示信息
	 * @param navTabId
	 *            重新载入标签页，如果无tabid参数，就载入当前标签页
	 * @param callbackType
	 *            callbackType如果是closeCurrent就会关闭当前tab
	 *            只有callbackType="forward"时需要forwardUrl值
	 * 
	 * @param forwardUrl
	 * @return JSON类型数据
	 */
	public static JSONObject returnFailedJson(String message,
			String navTabId,String callbackType,String forwardUrl) {
		Map<String, String> map = new HashMap<String, String>();
		map.put("statusCode", "300");
		map.put("message", message);
		map.put("navTabId", navTabId );
		map.put("callbackType", callbackType );
		map.put("forwardUrl", forwardUrl );
		return JSONObject.fromObject(map);
	}
	
	/**
	 * 返回 dwz 格式的json串（成功）
	 * 
	 * @param message
	 *            界面提示信息
	 * @param navTabId
	 *            重新载入标签页，如果无tabid参数，就载入当前标签页
	 * @param callbackType
	 *            callbackType如果是closeCurrent就会关闭当前tab
	 *            只有callbackType="forward"时需要forwardUrl值
	 * 
	 * @param forwardUrl
	 * @return JSON类型数据
	 */
	public static JSONObject returnSuccessJson(String message,
			String navTabId,String callbackType,String forwardUrl) {
		Map<String, String> map = new HashMap<String, String>();
		map.put("statusCode", "200");
		map.put("message", message);
		map.put("navTabId", navTabId );
		map.put("callbackType", callbackType );
		map.put("forwardUrl", forwardUrl );
		return JSONObject.fromObject(map);
	}
	
	
	public static void writer(HttpServletResponse response,Object data){
		PrintWriter writer;
		try {
			response.setCharacterEncoding("utf-8");
			writer = response.getWriter();
			writer.print(data);
			writer.flush();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public static DwzPage getPageData( DwzPage page, int num) {
		int nextPage = 1;// 下一页
		int backPage = 1;// 上一页
		int lastPage = 1;
		if (page.getPageNum() > 0) {
			nextPage = page.getPageNum() + 1;
			backPage = page.getPageNum() - 1;
		}

		if (page.getTotalCount() > 0) {
			if (page.getTotalCount() / num > 0) {
				if (page.getTotalCount() % num == 0) {
					lastPage = page.getTotalCount() / num;
				} else {
					lastPage = page.getTotalCount() / num + 1;
				}
			}

		}
		if (backPage < 1) {
			backPage = 1;
		}
		if (nextPage > lastPage) {
			nextPage = lastPage;
		}
		page.setNextPage(nextPage);
		page.setLastPage(lastPage);
		page.setBackPage(backPage);
		return page;
	}
}
