package com.bcxin.survey.utils;

import org.springframework.asm.Opcodes;

import com.sun.org.apache.bcel.internal.classfile.EmptyVisitor;

public class AnnotaionMetaDataReadingVisitor extends EmptyVisitor {
	
	private String className;

	private boolean isInterface;

	private boolean isAbstract;

	private String superClassName;

	private String[] interfaces;


	public void visit(int version, int access, String name, String signature, String supername, String[] interfaces) {
		this.className = convertResourcePathToClassName(name);
		this.isInterface = ((access & Opcodes.ACC_INTERFACE) != 0);
		this.isAbstract = ((access & Opcodes.ACC_ABSTRACT) != 0);
		if (supername != null) {
			this.superClassName = convertResourcePathToClassName(supername);
		}
		this.interfaces = new String[interfaces.length];
		for (int i = 0; i < interfaces.length; i++) {
			this.interfaces[i] = convertResourcePathToClassName(interfaces[i]);
		}
	}
	
	public String convertResourcePathToClassName(String path){
		if(path != null){
			return path.replace('/', '.');
		}
		return null;
	}


	public String getClassName() {
		return this.className;
	}

	public boolean isInterface() {
		return this.isInterface;
	}

	public boolean isAbstract() {
		return this.isAbstract;
	}

	public boolean isConcrete() {
		return !(this.isInterface || this.isAbstract);
	}

	public String getSuperClassName() {
		return this.superClassName;
	}

	public boolean hasSuperClass() {
		return (this.superClassName != null);
	}

	public String[] getInterfaceNames() {
		return this.interfaces;
	}

}


