package com.bcxin.survey.service.wechat;

import com.bcxin.survey.dao.report.BaseDao;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.survey.SurveySign;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
@Transactional
public class SurveySignServiceImpl implements SurveySignService  {
	
	@Autowired
	private BaseDao baseDao;

	@Override
	public boolean saveOrUpdate(SurveySign surveySign){
		boolean flag = true;
		try {
			surveySign.setUpdateOn(new Date());
			baseDao.saveOrUpdate(surveySign);		
		}catch(Exception e) {
			flag = false;
		}
		return flag;
	}

	@Override
	public boolean delete(SurveySign surveySign) {
		boolean flag = true;
		try {
			baseDao.delete(surveySign);		
		}catch(Exception e) {
			flag = false;
		}
		return flag;
	}

	@Override
	public SurveySign findSurveySignByOid(long oid){
		return baseDao.get(SurveySign.class, oid);
	}

	@SuppressWarnings("unchecked")
	@Override
	public SurveySign findSurveySignByUserAndDate(User user, Date signDate) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("user", user));
		criterionList.add(Restrictions.eq("signDate", signDate));
		List<SurveySign> surveySign = baseDao.findByCriterion(SurveySign.class, criterionList);
		if(surveySign.size() > 0) {
			return surveySign.get(0);
		}
		return null;
	}

	@SuppressWarnings("unchecked")
	@Override
	public SurveySign findSurveySignByPlanId(Long planId) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("planId", planId.toString()));
		List<SurveySign> surveySign = baseDao.findByCriterion(SurveySign.class, criterionList);
		if(surveySign.size() > 0) {
			return surveySign.get(0);
		}
		return null;
	}
		
}
