package com.bcxin.survey.service.common;

import com.alibaba.fastjson.JSON;
import com.bcxin.survey.communicate.sb.SBRspService;
import com.bcxin.survey.dao.report.ActivityDao;
import com.bcxin.survey.dao.report.MaterialTaskDao;
import com.bcxin.survey.dao.report.SyncTaskDao;
import com.bcxin.survey.domain.activity.Activity;
import com.bcxin.survey.domain.data.MaterialTask;
import com.bcxin.survey.domain.data.SyncTask;
import com.bcxin.survey.domain.survey.SurveyPlan;
import com.bcxin.survey.domain.survey.Survey_Questionnaire;
import com.bcxin.survey.dto.SBDataDTO;
import com.bcxin.survey.service.wechat.SurveyFeedBackService;
import com.bcxin.survey.service.wechat.SurveyPlanService;
import com.bcxin.survey.service.wechat.SurveyQuestionnaireService;
import com.bcxin.survey.utils.DictConst;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.concurrent.Future;

/**
 * 
 * <b>任务调度 </b>
 * 
 */
@Service
@Transactional
@Slf4j
public class ScheduleServiceImpl implements ScheduleService {

	@Resource
	private SurveyQuestionnaireService surveyQuestionnaireService;

	@Resource
	private SurveyFeedBackService surveyFeedBackService;

	@Resource
	private SurveyPlanService surveyPlanService;

	@Resource
	private SBRspService sbRspService;

	@Resource
	private MaterialTaskDao materialTaskDao;

	@Resource
	private ActivityDao activityDao;

	@Resource
	private SyncTaskDao syncTaskDao;


	@Override
	public void syncUnCompleteTask() {
		List<SyncTask> taskList = syncTaskDao.findUnCompleteTask();
		for (SyncTask task : taskList) {
			SBDataDTO dataDTO = JSON.parseObject(task.getParam(),SBDataDTO.class);
			try {
				Future<Boolean> future = sbRspService.sbAsync(dataDTO);
				if (future.get()) {
					task.setSuccess(DictConst.Y);
					syncTaskDao.update(task);
				}
			} catch (Exception e){
				log.error("定时任务执行失败：同步的任务id为" + task.getOid());
			}
		}
	}


	@Override
	public void syncUnCompleteMaterialTask() {
		List<MaterialTask> taskList = materialTaskDao.findUnCompleteTask();
		for (MaterialTask task : taskList) {
			try {
				if (DictConst.MATERIALTASK_TKXQ.equals(task.getMaterialTaskType())) {
					Activity activity = activityDao.findActivityByActivityNo(task.getActivityNo());
					SurveyPlan plan = surveyPlanService.findSurveyPlanByOid(Long.parseLong(task.getContent()));
					surveyFeedBackService.syncSurvey(activity,plan,task);
				} else if (DictConst.MATERIALTASK_TKBG.equals(task.getMaterialTaskType())) {
					Survey_Questionnaire surveyQuestionnaire = surveyQuestionnaireService.findQuestionnaireByOid(Long.parseLong(task.getContent()));
					surveyQuestionnaireService.createSurveyReport(surveyQuestionnaire,task);
				}
			} catch (Exception e){
				log.error("定时任务执行失败：同步的任务id为" + task.getOid());
			}
		}
	}
}
