package com.bcxin.survey.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

@JsonIgnoreProperties(value={"hibernateLazyInitializer"})
@Data
public class SurveyInfoDto implements Serializable {

	private static final long serialVersionUID = -8149334196024089736L;

	private String oid;

	private String question;//勘查题目

	private String answer; //结果


	public SurveyInfoDto(){}


	public SurveyInfoDto(Map<String,Object> map){
		this.oid = safeTransfor(map.get("oid"));
		this.question = safeTransfor(map.get("question"));
		this.answer = safeTransfor(map.get("answer"));
	}
	
	
	/**
     * 
     * <b>Function 将Object安全转换为String</b> 
     * 
     * @param obj
     * @return
     * @author LuoPeng
     * @date 2016年12月22日 下午5:17:02
     * @注意事项 </b>
     * <b>
     */
    private String safeTransfor(Object obj){
		if ( obj == null ) {
			return "";
		}
		return obj.toString();
	}
}