<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
	<title>我的任务</title>
	<%@ include file="/WEB-INF/views/include/wechatHead.jsp"%>
	<link rel="stylesheet" type="text/css" href="<c:url value='/resources/css/wechat/search.css?v=${version}'/>">
	<script type="text/javascript" src="<c:url value='/resources/commonJS/wechat/extendPagination.js?v=${version}'/>"></script>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/wechat/surveytask.js?v=${version}'/>"></script>
</head>
<body>
	<div style="display:flex; height:50px; line-height:50px;background:#FFF;border-bottom:1px solid #DDD;"  onclick="javascript:location.href='/wechat/index?_check=1'">
		<div style="width:5%;font-size:18px; padding-left:15px;">   <   </div>
		<div style="width:95%; text-align:center; text-indent:-10px; font-size:18px;">   我的任务   </div>
	</div>

	<div class="weui-search-bar" id="search_bar">
        <form class="weui-search-bar__form">
            <div class="weui-search-bar__box">
                <i class="weui-icon-search"></i>
                <input type="search" class="weui-search-bar__input" id="search_input" placeholder="请输入关键词" onblur="searchBlur();" onfocus="searchFocus();">
            </div>
            <label for="search_input" class="weui-search-bar__label" id="search_text">
                <i class="weui-icon-search"></i>
                <span>请输入关键词</span>
            </label>
        </form>
        <a href="javascript:void(0);" class="weui-search-bar__cancel-btn" id="search_cancel" onclick="searchResult();">确定</a>
    </div>
	<div class="task-tabs">
		<ul class="nav nav-tabs">
			  <li class="active"><a href="#" data-toggle="tab" onclick="choiseStatus(this,'DISTRIBUTE')">未接受</a></li>
			  <li><a href="#" data-toggle="tab" onclick="choiseStatus(this,'DONE')">已完成</a></li>
			  <li><a href="#" data-toggle="tab" onclick="choiseStatus(this,'DOING')">进行中</a></li>
			  <li><a href="#" data-toggle="tab" onclick="choiseStatus(this,'ALL')" >全部</a></li>
		</ul> 
		<div class="tab-content">
		  <div class="tab-pane active" id="taskArea">
		  	<table class="table"> 
			  <thead>
			    <tr>
			      <th>活动名称</th>
			      <th>活动时间</th>
			      <th>活动地点</th>
			      <th>联系人</th>
					<th>勘查专家</th>
			      <th>状态</th>
			      <th>操作</th>
			    </tr>
			  </thead>
			  <tbody id="taskList">
			  	<c:choose>
			  		<c:when test="${empty taskList }">
			  			<tr><td colspan="7" style="text-align: center;">无相关数据</td></tr>
			  		</c:when>
			  		<c:otherwise>
			  			<c:forEach items="${taskList }" var="surveyTask">
							<tr>
								<td>${surveyTask.activityName }</td>
								<td>${surveyTask.startDate }<br>-<br>${surveyTask.endDate }</td>
								<td>${surveyTask.address }&nbsp;</td>
								<td>${surveyTask.contacts }<br/>${surveyTask.contactMobile }&nbsp;</td>
								<td>
									<c:if test="${not empty surveyTask.tkExperts}">
										<c:if test="${not empty surveyTask.tkExperts}">
											<c:set value="${fn:split(surveyTask.tkExperts,',')}" var="experts" />
											<c:forEach items="${experts}" var="item">
												${item}<br/>
											</c:forEach>
										</c:if>
									</c:if>
									<c:if test="${ empty surveyTask.tkExperts}">
										--
									</c:if>
								</td>
								<td id="showStatus${surveyTask.oid }">${surveyTask.surveyTaskStatusName }</td>
								<td id="showBt${surveyTask.oid }">
									<c:if test="${surveyTask.surveyTaskStatus eq 'DISTRIBUTE' }">
										<a href="javascript:void(0);" onclick="receiveTask('${surveyTask.oid }');">接受 |</a> 
										<a href="javascript:void(0);" onclick="refuse('${surveyTask.oid }');">拒绝</a>
									</c:if>
									<c:if test="${surveyTask.surveyTaskStatus eq 'DOING'}">						
										<a href="javascript:taskDetail('${surveyTask.oid }');" id="planBtn">查看详情</a>	
									</c:if>
								</td>
							</tr>
						</c:forEach>
			  		</c:otherwise>
			  	</c:choose>
			  </tbody>
			</table>
			<form id="taskForm">
            	<input type="hidden" name="surveyTaskStatus" id="surveyTaskStatus" value="ALL">
            	<input type="hidden" name="search" id="search" value="">
            	<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
            	<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
            	<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
            	<c:if test="${not empty taskList }">
            		<div id="callBackPager" style="margin: 0 auto;text-align: center;"></div>
            	</c:if>
            </form>
		  </div>
		</div>
	</div>
</body>
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';
	
	var totalCount = Number($('#totalCount').val()) || 0;
	var showCount = $('#showCount').val() || 5;
	var limit = Number($('#numPerPage').val()) || 10;
	$('#callBackPager').extendPagination({
		totalCount: totalCount,
		showCount: showCount,
		limit: limit,
		callback: function (curr, limit, totalCount) {
			getListForPage("taskForm","taskList");
		}
	});

</script>
</html>

