<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
<title>勘查问卷</title>
	<%@ include file="/WEB-INF/views/include/wechatHead.jsp"%>

<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';

	function wechatCloseForm() {
		WeixinJSBridge.call('closeWindow');
	}

	function viewQuestion(planId) {
		window.location.assign(baseUrl + "/wechat/question/viewQuestion?planId=" + planId);
	}

	function editQuestion(planId) {
		window.location.assign(baseUrl + "/wechat/question/editQuestion/" + planId);
	}
	function alertQuestion() {
		layer.msg('计划信息初始化异常，请返回对计划进行修改操作');
	}

	function siteSurveyView(planId) {
		window.location.assign(baseUrl + "/wechat/survey/siteSurveyView/" + planId);
	}

	function siteSurvey() {
		window.location.assign(baseUrl + "/wechat/survey/siteSurvey/init");
	}
</script>

</head>
<body>
	<div class="container-fluid bg-6f pt-10 pb30">
		<div class="issue-title text-center">
			<h4>${surveyTask.name }</h4>
		</div>
	</div>
	<div class="clear"></div>
	<div class="tab-content nmt-10">
		<table class="table">
			<thead class="bg-ececec">
				<tr>
					<th>勘查次数</th>
					<th>勘查阶段</th>
					<th>勘查时间</th>
					<th>勘查场地</th>
					<th>状态</th>
					<th>操作</th>
				</tr>
			</thead>
			<tbody class="plan-war">
				<c:if test="${empty planList }">
					<tr><td colspan="6" style="text-align: center;">无相关数据</td></tr>
				</c:if>
				<c:forEach items="${planList }" var="surveyPlan">
				<tr>
					<td>第${surveyPlan.time }次勘查</td>
					<td>${surveyPlan.surveyStep.name }</td>
					<td>
						<c:if test="${surveyPlan.allDay}">
							<fmt:formatDate value='${surveyPlan.beginTime }' pattern='yyyy-MM-dd' />
							<br/>-<br/>
							<fmt:formatDate value='${surveyPlan.endTime }' pattern='yyyy-MM-dd' />
						</c:if>
						<c:if test="${!surveyPlan.allDay}">
							<fmt:formatDate value='${surveyPlan.beginTime }' pattern='yyyy-MM-dd HH:mm' />
							<br/>-<br/>
							<fmt:formatDate value='${surveyPlan.endTime }' pattern='yyyy-MM-dd HH:mm' />
						</c:if>
					</td>
					<td>${surveyPlan.venue.name }</td>
					<td class="${surveyPlan.taskStatus eq 'COMPLETE' || surveyPlan.taskStatus eq 'CLOSE' ? 'c-49a61a':'c-f98718'}">
						${surveyPlan.taskStatus.getName() }</td>
					<td>
						<c:choose>
							<c:when test="${ surveyPlan.questionnaire.generate }">
								<c:choose>
									<c:when test="${surveyPlan.taskStatus eq 'COMPLETE' }">
										<a href="javascript:siteSurveyView('${surveyPlan.oid }');">勘查详情</a>
									</c:when>
									<c:otherwise>
										<c:if test="${surveyPlan.questionnaire.taskStatus eq 'CONTINUE' && surveyTask.surveyTaskStatus ne 'OBSOLETE'  }">
											<a href="javascript:viewQuestion('${surveyPlan.oid }');">预览问卷</a>
										</c:if>
										<c:if test="${surveyPlan.questionnaire.taskStatus eq 'NON' && surveyTask.surveyTaskStatus ne 'OBSOLETE' }">
											<a href="javascript:editQuestion('${surveyPlan.oid }');">修改</a>|
											<a href="javascript:viewQuestion('${surveyPlan.oid }');">预览</a>
										</c:if>
									</c:otherwise>
								</c:choose>
							</c:when>
							<c:otherwise>
								<c:if test="${ surveyTask.surveyTaskStatus ne 'OBSOLETE' &&( surveyPlan.questionnaire.taskStatus eq 'NON' || surveyPlan.questionnaire.taskStatus eq 'CONTINUE')}">
									<a href="javascript:editQuestion('${surveyPlan.oid }');">维护问卷</a>
								</c:if>
							</c:otherwise>
						</c:choose>&nbsp;
						<c:if test="${empty surveyPlan.questionnaire}">
							<a href="javascript:alertQuestion();">提示</a>
						</c:if>
					</td>
				</tr>
				</c:forEach>
			</tbody>
		</table>
	</div>
	<div class="text-center submit-btn">
<!-- 		<button type="button" class="btn btn-primary bg-2e9fe3" onclick="siteSurvey();">前往勘查</button> -->
		<a class="btn btn-primary bg-2e9fe3" href="<c:url value='/wechat/question/init'/>">返回</a>
	</div>
</body>
</html>

