package com.bcxin.survey.utils.sms;


import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.survey.utils.*;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;

@Slf4j
@Component
public class SMSUtil {

	private static final String KEY = "bcxinABCXIN$1012 ";
	private static final String CHANNEL = "pss";

	@Async
	public static Future<Boolean> sendSMS(String to, String content) {
		//如果是开发环境，屏蔽调用短信接口
		String envi = ConfigUtil.envi();
		if (Objects.equals(envi, "dev") || Objects.equals(envi, "test")) {
			return new AsyncResult<Boolean>(false);
		}

		// 不需要发送短信，直接返回
		if(!GlobalResources.isOpenSendMsg){
			return new AsyncResult<Boolean>(false);
		}

		if (StringUtil.isEmpty(to)) {
			return new AsyncResult<Boolean>(false);
		}

		String url = "http://msg.bcxin.com.cn:9165/sms/sendMessage";
		// 开始时间
		String requestId = System.currentTimeMillis() + "";
		JSONObject json = new JSONObject();
		json.put("type",CHANNEL);
		//内容
		json.put("content", content);
		//手机号码
		json.put("mobile", to);
		json.put("requestId",requestId);
		//秘钥
		json.put("token", MD5Util.string2MD5(requestId + CHANNEL + KEY));
		try {
			String ret = RequestUtil.initHttp().doPost(url, json.toString(), "application/json", "UTF-8");
			JSONObject  retJson = JSONObject.parseObject(ret);
			if (retJson.get("status").equals("200")) {
				System.out.println("短信发送成功，手机号：["+to+"]，短信内容：["+content+"]");
				return new AsyncResult<Boolean>(true);
			} else {
				System.out.println("短信发送失败，手机号：["+to+"]，短信内容：["+content+"]");
				return new AsyncResult<Boolean>(false);
			}
		} catch (Exception ex){
			System.out.println("短信发送失败，手机号：["+to+"]，短信内容：["+content+"]");
			return new AsyncResult<Boolean>(false);
		}
	}

	@Async
	public Future<Boolean> sendHuaWeiSMS(HuaWeiSmsContent huaWeiSmsContent){
		//如果是开发环境，屏蔽调用短信接口
		String envi = ConfigUtil.envi();
		if (Objects.equals(envi, "dev") || Objects.equals(envi, "test")) {
			return new AsyncResult<Boolean>(false);
		}
		String url = ConfigUtil.getValue("sms_huawei_url");
		List<NameValuePair> params = Lists.newArrayList();
		params.add(new BasicNameValuePair("data", JSON.toJSONString(huaWeiSmsContent)));
		params.add(new BasicNameValuePair("token", MD5Util.string2MD5("BCXIN" + huaWeiSmsContent.getMobile() + DateUtil.today())));
		HttpUtil.sendPostRequest(url, params);
		System.out.println("短信发送成功，手机号：["+huaWeiSmsContent.getMobile()+"]，短信内容：["+huaWeiSmsContent.getParams()+"]");
		return new AsyncResult<Boolean>(true);
	}

	public static String platFormName() {
		return ConfigUtil.getValue("platform_name");
	}

}
