package com.bcxin.survey.utils;

import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Paragraph; 
import com.lowagie.text.Phrase;
import com.lowagie.text.rtf.field.RtfPageNumber;
import com.lowagie.text.rtf.field.RtfTotalPageNumber;
import com.lowagie.text.rtf.headerfooter.RtfHeaderFooter;
import com.lowagie.text.rtf.style.RtfFont;

public class DocStyleUtils {
	
    /** 
     * 功能说明：设置段落的样式，一般用于设置标题</BR> 
     * 修改日期：2011-04-27 
     * @author myclover 
     * @param content  段落的内容 
     * @param font     字体样式 
     * @param leading  行间距 
     * @param alignment 对齐方式 
     * @return 
     */  
    public static Paragraph setParagraphStyle(String content , RtfFont font , float leading , int alignment){  
        return setParagraphStyle(content, font, 0f, leading, 0f, alignment);  
    }  

    /** 
     * 功能说明：设置段落的样式，对齐方式为两端对齐，缩进样式是文本之后0.2毫米</BR> 
     * 修改日期：2011-04-27 
     * @author myclover 
     * @param content  段落的内容 
     * @param font     字体的样式 
     * @param firstLineIndent 首行缩进多少字符，16f约等于一个字符 
     * @param leading  行间距 
     * @return 
     */  
    public static Paragraph setParagraphStyle(String content , RtfFont font , float firstLineIndent , float leading, int alignment){  
        return setParagraphStyle(content, font, firstLineIndent, leading, 0.6f, alignment);  
    }  

    /** 
     * 功能说明：设置段落的样式</BR> 
     * 修改日期：2011-04-27 
     * @author myclover 
     * @param content  段落的内容 
     * @param font     字体的样式 
     * @param firstLineIndent  首行缩进多少字符，16f约等于一个字符 
     * @param leading  行间距 
     * @param indentationRight 缩进样式中的文本之后多少毫米，0.6f相当于0.2毫米 
     * @param alignment 对齐方式 
     * @return 
     */  
    public static Paragraph setParagraphStyle(String content , RtfFont font , float firstLineIndent , float leading , float indentationRight , int alignment){  
        Paragraph par = new Paragraph(content, font);  
        System.out.println(par.getLeading());
        par.setFirstLineIndent(firstLineIndent);  
        par.setIndentationRight(indentationRight);  
        par.setAlignment(alignment); 
        par.setLeading(leading);
        return par;  
    }  
    
    public static HeaderFooter setHeaderStyle(String headerContext, RtfFont headerFont){
    	Phrase headerPara = new Phrase(); 
		headerPara.add(headerContext);
		headerPara.setFont(headerFont);
        HeaderFooter header = new RtfHeaderFooter(headerPara);  
        header.setAlignment(Paragraph.ALIGN_CENTER);
        return header;
    }
    
    public static HeaderFooter setFooter(){
    	Paragraph parafooter = new Paragraph();
		parafooter.add(new Phrase("第"));
		parafooter.add(new RtfPageNumber());
		parafooter.add(new Phrase("页/共"));
		parafooter.add(new RtfTotalPageNumber());
		parafooter.add(new Phrase("页"));
		HeaderFooter footer = new RtfHeaderFooter(parafooter);
        footer.setAlignment(Paragraph.ALIGN_CENTER); 
        return footer;
    }
}
