package com.bcxin.survey.service.wechat;

import com.bcxin.survey.domain.report.Task;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.survey.SurveyTask;
import com.bcxin.survey.enums.report.SurveyTaskStatus;
import com.bcxin.survey.vo.DwzPage;
import com.bcxin.survey.wechat.response.TaskNoticeTemplate;
import net.sf.json.JSONObject;
import scala.Int;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface SurveyTaskService {

	boolean saveOrUpdate(SurveyTask surveyTask);
	
	SurveyTask findSurveyTaskByOid(long oid);
	
	SurveyTask findSurveyTaskByTaskIdAndUserId(long taskId,long userId);
	
	SurveyTask findSurveyTaskByTaskIdAndUser(long taskId,User user);
	
	SurveyTask findSurveyTaskByUserAndTaskCode(User user, String taskCode);

	SurveyTask findSurveyTaskByUserAndStatus(User user, SurveyTaskStatus status);

	SurveyTask findSurveyTaskByUserAndTaskCodeAndStatus(User user,String taskCode ,SurveyTaskStatus status);
	
	List<SurveyTask> findSurveyTaskListByUserAndStatus(User user, SurveyTaskStatus status);
	
	List<SurveyTask> findSurveyTaskListByUserAndStatusForPage(User user,String surveyName, SurveyTaskStatus status,DwzPage page);

	List<SurveyTask> findUnFinishedSurveyTaskListByUser(User user);
	
	List<SurveyTask> findUnFinishedSurveyTaskListByUserForPage(User user,DwzPage page);
	
	List<SurveyTask> findSurveyTaskListByStatus(SurveyTaskStatus status);

	List<SurveyTask> findSurveyTaskListByUserAndStatusAndDateForMonth(User user, SurveyTaskStatus status, Date month);
	
	List<SurveyTask> findSurveyTaskListByUserAndStatusAndDateForDay(User user, SurveyTaskStatus status, Date day);
	
	TaskNoticeTemplate getTaskNoticeTemplate(SurveyTask surveyTask,String taskNoticeTemplateId,String url);

	void sendWeixinMsg(SurveyTask surveyTask);

	boolean transferTask(SurveyTask surveyTask);

	void distributeTask(Task task);

	JSONObject receiveTask(Long taskId);

	JSONObject refuseTask(Long taskId);
	
	SurveyTask findSurveyTaskByReportOid(long oid);

	SurveyTask findSurveyTaskByTaskId(long taskId);

	User selectExpertBySurveyTaskId(long taskId);

	List<Map<String,Object>> selectExpertBySurveyTaskIdList(List<Long> taskIdList);

	Integer selectStepExpert(Long taskId);

	String selectStepExpertName(Long taskId);

	String selectStepExpertName(Long taskId,String surveyStep);

	List<Map<String,Object>> findSurveyTaskListByUserForPage(User user,String surveyName,SurveyTaskStatus status,DwzPage page);

}