package com.bcxin.survey.service.manage;

import cn.hutool.core.bean.BeanUtil;
import com.bcxin.survey.dao.report.BaseDao;
import com.bcxin.survey.dto.SurveyReportSearchDto;
import com.bcxin.survey.dto.SurveyReportVo;
import com.bcxin.survey.enums.report.SurveyStep;
import com.bcxin.survey.utils.StringUtil;
import com.bcxin.survey.vo.DwzPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2018/07/20 0020.
 */
@Service
@Transactional
public class SurveyReportManageServiceImpl implements SurveyReportManageService{

    @Autowired
    private BaseDao baseDao;

    @Override
    public List<SurveyReportVo> findReportListForPage(SurveyReportSearchDto searchDto, DwzPage page) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT questionnaire.oid,task.`name` as 'activityName',venue.`name` as 'venueName',questionnaire.surveyStep ");
        sql.append(" FROM risk_surveytask task");
        sql.append(" INNER JOIN risk_survey_feedback feedback on feedback.taskId=task.oid");
        sql.append(" INNER JOIN risk_survey_questionnaire questionnaire on questionnaire.feedBackId= feedback.oid");
        sql.append(" INNER JOIN sys_venue venue on questionnaire.venueId= venue.oid");
        sql.append(" where (questionnaire.reportPath is not null or questionnaire.taskStatus ='COMPLETE')");
        if(StringUtil.isNotEmpty(searchDto.getActivityName())){
            sql.append(" and task.`name` like '%"+searchDto.getActivityName() +"%'");
        }

        if(page != null){
            if(StringUtil.isNotEmpty(page.getHtml())){
                sql.append(" and task.`name` like '%"+ page.getHtml() +"%'");
            }
            Integer count = baseDao.findCountBySQL(sql.toString(),null);
            page.setTotalCount(count);
            sql.append(" limit "+page.getNumPerPage()*(page.getPageNum()-1)+","+page.getNumPerPage());
        }
        List<Map<String,Object>> list = baseDao.findBySQL(sql.toString(),null);

        List<SurveyReportVo> reportVoList = new ArrayList<SurveyReportVo>();
        list.forEach(map->{
            String surveyStep = map.containsKey("surveyStep") ? map.get("surveyStep").toString() : "";
            surveyStep = SurveyStep.convert(surveyStep).getName();
            map.put("surveyStep",surveyStep);
            SurveyReportVo reportVo = BeanUtil.mapToBean(map,SurveyReportVo.class,true);
            reportVoList.add(reportVo);
        });
        return reportVoList;
    }
}
