package com.bcxin.survey.controller.manage;

import com.bcxin.survey.base.BaseController;
import com.bcxin.survey.domain.survey.SurveyAssist;
import com.bcxin.survey.enums.report.AssignType;
import com.bcxin.survey.service.UserService;
import com.bcxin.survey.service.manage.SurveyAssistManageService;
import com.bcxin.survey.service.manage.TaskManageService;
import com.bcxin.survey.service.report.TaskService;
import com.bcxin.survey.service.wechat.SurveyAssistService;
import com.bcxin.survey.service.wechat.SurveyTaskService;
import com.bcxin.survey.utils.DateUtil;
import com.bcxin.survey.vo.DwzPage;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/manage/survey")
public class SurveyManageController extends BaseController {

	@Autowired
	private UserService userService;
	
	@Autowired
	private SurveyAssistManageService surveyAssistManageService;	
	
	@Autowired
	private SurveyAssistService surveyAssistService;	
	
	@Autowired
	private TaskManageService taskManageService;

	@Autowired
	private SurveyTaskService surveyTaskService;
	
	@Autowired
	private TaskService taskService;
	
	@RequestMapping("/transferTask")
	public Map<String,String> transferTask(SurveyAssist surveyAssist){
		return surveyAssistManageService.transferTask(surveyAssist);
	}
	
	@RequestMapping("assistList/init")
	public ModelAndView assistListInit() {
		ModelAndView view = new ModelAndView("/manage/survey/assistList");
		return view;
	}
	
	@RequestMapping("findAssistListForPage")
	@ResponseBody
	public JSONObject findAssistListForPage(DwzPage page,HttpServletRequest request){
		JSONObject json = new JSONObject();
		JSONArray arr = new JSONArray();
		List<SurveyAssist> assistList = surveyAssistManageService.findSurveyAssistListForPage(page);
		for (SurveyAssist assist : assistList) {
			JSONObject assistObj = new JSONObject();
			assistObj.put("id", assist.getOid());
			assistObj.put("surveyTask", assist.getSurveyTask().getName());
			assistObj.put("assignType", assist.getAssignType().getName());
			assistObj.put("user", assist.getUser().getRealName());
			assistObj.put("reason", assist.getReason());
			assistObj.put("assignStatusValue", assist.getAssignStatus());
			assistObj.put("assignStatus", assist.getAssignStatus().getName());
			assistObj.put("createOn", DateUtil.convertDateToString(assist.getCreateOn(), "YYYY-MM-dd HH:mm:00") );
			arr.add(assistObj);
		}
		json.put("entNum", 10);
		json.put("order", "asc");
		json.put("sortName", "id");
		json.put("startNum", 0);
		json.put("total", page.getTotalCount());
		json.put("rows", arr);

		return json;
	}
	
	@RequestMapping("/approvalAssist/{oid}")
	public ModelAndView approvalAssistInit(@PathVariable Long oid){
		ModelAndView view = new ModelAndView();
		SurveyAssist surveyAssist = surveyAssistService.findSurveyAssistByOid(oid);
		view.addObject("surveyAssist", surveyAssist);
		if(surveyAssist.getAssignType().equals(AssignType.APPLYEXPERT)){
			view.setViewName("/manage/survey/editExpert");
			view.addObject("expertList",userService.findActivityExpertUser(surveyAssist));
		} else {
			view.setViewName("/manage/survey/transferTask");
		}
		return view;
	}
	
	@RequestMapping("editExpert/{oid}")
	public ModelAndView editExpertInit(@PathVariable Long oid) {
		ModelAndView view = new ModelAndView("/manage/survey/editExpert");
		SurveyAssist surveyAssist = surveyAssistService.findSurveyAssistByOid(oid);
		view.addObject("surveyAssist", surveyAssist);
		view.addObject("expertList",userService.findActivityExpertUser(surveyAssist));
		return view;
	}
	
	@RequestMapping("/editExpert")
	public Map<String, String> editExpert(SurveyAssist surveyAssist) {
		return surveyAssistManageService.editExpert(surveyAssist);
	}
}
