<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
<title>问卷预览</title>

	<%@ include file="/WEB-INF/views/include/wechatHead.jsp"%>
	<link rel="stylesheet" type="text/css" href="${ctxStatic }/wechat2/dist/css/survey-ques.css?v=${version}" />
</head>
<body>
	<div  class="container-fluid bg-6f pt-10">
		<div class="issue-title text-center">
			<h4>${surveyPlan.surveyTask.name }</h4>
			<p>第${surveyPlan.time }次勘查 ${surveyPlan.surveyStep.name } ${surveyPlan.venue.name }</p>
		</div>
		</div> 
		<div class="issue-content">
			<div class="isscon-title"><h4>固定问题</h4></div> 
			<c:set var="questionIndex" value="1" />
			<c:forEach items="${surveyInfos }" var="surveyInfo">
			<c:if test="${surveyInfo.questionType eq 'FIXED' }">
			<div class="issue-consub">
				<h5>${questionIndex}、${surveyInfo.question }</h5>
				<p>${surveyInfo.answerTip }</p>
			</div>
			<c:set var="questionIndex" value="${questionIndex+1 }" />
			</c:if>
			</c:forEach>
		</div>
		<div class="issue-content">
			<div class="isscon-title"><h4>遗留问题</h4></div> 
			<c:forEach items="${surveyInfos }" var="surveyInfo">
			<c:if test="${surveyInfo.questionType eq 'CARRYOVER' }">
			<div class="issue-consub">
				<h5>${questionIndex}、${surveyInfo.question }</h5>
				<p>${surveyInfo.answerTip }</p>
				<c:if test="${ not empty surveyInfo.lastSurvey.photos }">
				<div class="list-img clearfix">
					<ul>
						<c:forEach items="${ surveyInfo.lastSurvey.photos }" var="photo">
						<li class="portrait">
							<img class="pic" src="${photo.path }" onclick="preViewImg('${photo.path}');"/>
						</li>
						</c:forEach>
					</ul>
				</div>
				</c:if>
			</div>
			<c:set var="questionIndex" value="${questionIndex+1 }" />
			</c:if>
			</c:forEach>
		</div>
		<div class="issue-content">
			<div class="isscon-title"><h4>开放问题</h4></div> 
			<div class="issue-list">
				<ul>
					<c:forEach items="${surveyInfos }" var="question" varStatus="quesStatus">
						<c:if test="${question.questionType eq 'UNFIXED' }">
							<li>${questionIndex }、${question.question }</li>
							<c:set var="questionIndex" value="${questionIndex+1 }" />
						</c:if>
					</c:forEach>
				</ul>
			</div>
		</div>
		<div class="issue-content">
			<div class="isscon-title"><h4>补充问题</h4></div> 
			<div class="issue-list">
				<ul>
					<c:forEach items="${surveyInfos }" var="question" varStatus="quesStatus">
						<c:if test="${question.questionType eq 'SUPPLEMENT' }">
							<li>${questionIndex }、${question.question }</li>
							<c:set var="questionIndex" value="${questionIndex+1 }" />
						</c:if>
					</c:forEach>
				</ul>
			</div>
		</div>
		<div class="text-center submit-btn">
			<c:if test="${questionnaire.taskStatus eq 'NON' || questionnaire.taskStatus eq 'CONTINUE'}">
				<c:if test="${questionnaire.taskStatus eq 'NON' }">
					<a href="javascript:editQuestion('${surveyPlan.oid }');" class="btn btn-primary bg-2e9fe3">修改问卷</a>
				</c:if>
				<a href="javascript:siteSurvey('${surveyPlan.oid }');" class="btn btn-primary bg-2e9fe3">立即勘查</a>
			</c:if>
			<a href="javascript:gotoQuestionInit('${surveyPlan.surveyTask.oid }');" class="btn btn-primary bg-2e9fe3">返回</a>
		</div>
	
	<script src="<c:url value='/resources/commonJS/wechat/wechat.js?v=${version}'/>" type="text/javascript"></script>
	<script type="text/javascript" src="https://res.wx.qq.com/open/js/jweixin-1.2.0.js"></script>
</body>
<script type="text/javascript">

	var baseUrl = '${pageContext.request.contextPath }';
	
	wx.config({
		debug : false, // 开启调试模式,调用的所有api的返回值会在客户端alert出来，若要查看传入的参数，可以在pc端打开，参数信息会通过log打出，仅在pc端时才会打印。
		appId : '${appid}', // 必填，公众号的唯一标识
		timestamp : '${timestamp}', // 必填，生成签名的时间戳
		nonceStr : '${noncestr}', // 必填，生成签名的随机串
		signature : '${sign}',// 必填，签名，见附录1
		jsApiList : [ 'closeWindow', 'chooseImage', 'previewImage', 'uploadImage' ]
	// 必填，需要使用的JS接口列表，所有JS接口列表见附录2
	});
	
	wx.ready(function() {
		//判断当前客户端版本是否支持指定JS接口
		wx.checkJsApi({
			jsApiList : [ 'chooseImage' ], // 需要检测的JS接口列表，所有JS接口列表见附录2,
			success : function(res) {
				// 以键值对的形式返回，可用的api值true，不可用为false
				// 如：{"checkResult":{"chooseImage":true},"errMsg":"checkJsApi:ok"}
			}
		});
		//隐藏右上角菜单接口
		wx.hideOptionMenu();
	});
	function editQuestion(questionnaireId) {
		window.location.assign(baseUrl + "/wechat/question/editQuestion/" + questionnaireId);
	}
	
	function gotoQuestionInit(taskId){
		window.location.assign(baseUrl + "/wechat/question/questionList/init/"+taskId);
	}
	
	function siteSurvey(planId) {
		window.location.assign(baseUrl + "/wechat/survey/siteSurveyByPlanId/"+planId);
	}
		
</script>
</html>

