<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<c:if test="${not empty surveyInfos}">
	<div class="choosable_war browse_war" id="leaveArea">
		<div class="issue-content">
			<div class="isscon-title"><h4>遗留问题</h4></div>
			<c:forEach items="${surveyInfos }" var="surveyInfo">
			<div class="issue-consub">
				<h5 class="hand-down clearfix">
					<span class="check-box">
						<input name="nextSurveys" value="${surveyInfo.oid }" id="unFixed${surveyInfo.oid }" ${surveyInfo.nextSurvey ? "checked='checked'":"" } type="checkbox">
						<label for="unFixed${surveyInfo.oid }"></label>
					</span>
					<span><label for="unFixed${surveyInfo.oid }">${surveyInfo.question }</label></span>
				</h5>
				<c:if test="${not empty surveyInfo.answer  }"><p>${surveyInfo.answer }</p></c:if>
				<c:if test="${ not empty surveyInfo.photos }">
				<div class="list-img clearfix">
					<ul>
						<c:forEach items="${ surveyInfo.photos }" var="photo">
						<li class="portrait">
							<img class="pic" src="${photo.path }" onclick="preViewImg('${photo.path}');"/>
						</li>
						</c:forEach>
					</ul>
				</div>
				</c:if>
			</div>
			</c:forEach>
	</div>
		<div class="text-center submit-btn">
			<a href="javascript:firstStep();" class="btn btn-primary bg-2e9fe3">上一步</a>
			<a href="javascript:nextStep();" class="btn btn-primary bg-2e9fe3">下一步</a>
		</div>
	</div>
</c:if>
<div class="choosable_war browse_war" id="labelArea"
	${not empty surveyInfos ? 'style="display: none;"':'' }>
	<div class="issue-content">
			<div class="isscon-title"><h4>开放问题</h4></div>
			<div class="issue-consub">
				<h5>请选择标签分类：</h5>
				<div class="classify-war clearfix">
					<ul>
						<c:forEach items="${tagList}" var="tag">
							<li>
								<span class="check-box">
									<input type="checkbox"id="tag${tag.oid }" value="${tag.oid }" onclick="choiseTagType(this);">
									<label for="tag${tag.oid }"></label>
								</span>
								<span><label for="tag${tag.oid }">${tag.name }</label></span>
							</li>
						</c:forEach>
					</ul>
				</div>
			</div>
			<div class="issue-consub">
				<h5>请选择二级标签：</h5>
				<div class="classify-war clearfix" id="subTag"></div>
			</div>
			<div class="issue-consub">
				<h5>请选择要添加的问题：</h5>
				<div class="addissue-war">
					<ul id="tagsQuestionArea"></ul>
				</div>
				<div class="submit-btn"><a href="javascript:addOptionalQuestion();" class="btn btn-primary bg-2e9fe3">添加</a></div>
			</div>
		</div>
		<div class="issue-content">
			<div class="isscon-title"><h4>补充问题</h4></div>
			<div class="issue-consub">
				 <div class="addissue-input">
					<input type="text" id="question" name="questions" placeholder="请输入要添加的问题">
					<img src="<c:url value='/resources/wechat2/images/add-issue.jpg'/>" class="add-btn" width="22" height="22" onclick="addQuestion();"/>
				</div>
				<h5>已添加问题：</h5>
				<div class="alreadyissue" id="questionListArea">
					<c:set var="questionIndex" value="1" />
					<ul>
						<c:forEach items="${questionnaire.surveyInfos }" var="question" varStatus="status">
						<c:if test="${ question.questionType eq 'UNFIXED' || question.questionType eq 'SUPPLEMENT' }">
						<li id="quesId${question.oid }">${questionIndex }、<span class='c-f98718'>(${question.questionType.name })</span>${question.question}<img src="<c:url value='/resources/wechat2/images/delete-issue.jpg'/>" width="22" height="22" onclick="removeQuestion('${question.oid }');"></li>
						<c:set var="questionIndex" value="${questionIndex + 1 }" />
						</c:if>
						</c:forEach>
					</ul> 
				</div>
			</div> 
		</div> 
		<div class="text-center submit-btn">
			<a href="javascript:lastStep();" class="btn btn-primary bg-2e9fe3">上一步</a>
			<a href="javascript:submitForm();" class="btn btn-primary bg-2e9fe3">生成问卷</a>
			<a href="<c:url value='/wechat/question/questionList/init/${questionnaire.feedBack.surveyTask.oid }'/>" class="btn btn-primary bg-2e9fe3">返回</a>
		</div>
</div>
<script>
	var questionSize = '${questionnaire.surveyInfos.size() }';
	function nextStep() {
		$("#leaveArea").hide();
		$("#labelArea").show();
	}
	
	function lastStep(){
		if($("#leaveArea").html() == 'undefined' || $("#leaveArea").html() == undefined){
			$("#fixedArea").show();
		}else
			$("#leaveArea").show();
		$("#labelArea").hide();
	}
	
	function firstStep(){
		$("#leaveArea").hide();
		$("#fixedArea").show();
	}
	
</script>