package com.bcxin.survey.service.wechat;

import com.bcxin.survey.dao.report.BaseDao;
import com.bcxin.survey.dao.report.CMSDao;
import com.bcxin.survey.domain.survey.SurveyTag;
import com.bcxin.survey.enums.report.TagType;
import com.bcxin.survey.utils.StringUtil;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
@Transactional
public class SurveyTagServiceImpl implements SurveyTagService {

	@Autowired
	private BaseDao baseDao;
	@Autowired
	private CMSDao cmsDao;

	@Override
	public boolean saveOrUpdate(SurveyTag surveyTag){
		boolean flag = true;
		try {
			surveyTag.setUpdateOn(new Date());
			baseDao.saveOrUpdate(surveyTag);		
		}catch(Exception e) {
			flag = false;
		}
		return flag;
	}

	@Override
	public boolean delete(SurveyTag surveyTag) {
		boolean flag = true;
		try {
			baseDao.delete(surveyTag);		
		}catch(Exception e) {
			flag = false;
		}
		return flag;
	}

	@Override
	public SurveyTag findSurveyTagByOid(long oid){
		return baseDao.get(SurveyTag.class, oid);
	}


	@Override
	public SurveyTag findSurveyTagByName(String name){
		List<Criterion> criterionList = new ArrayList<Criterion>();
		if(StringUtil.isNotEmpty(name)) {
			criterionList.add(Restrictions.eq("name", name));
		}else {
			return null;
		}
		List<SurveyTag> surveyTags = baseDao.findByCriterion(SurveyTag.class,criterionList);
		if(surveyTags != null && surveyTags.size()>0) {
			return surveyTags.get(0);
		}
		return null;
	}


	@Override
	public SurveyTag findSurveyTagByNameAndType(String name,TagType type){
		List<Criterion> criterionList = new ArrayList<Criterion>();
		if(StringUtil.isNotEmpty(name)) {
			criterionList.add(Restrictions.eq("name", name));
		}else {
			return null;
		}
		if(type != null) {
			criterionList.add(Restrictions.eq("tagType", type));
		}else {
			return null;
		}
		List<SurveyTag> surveyTags = baseDao.findByCriterion(SurveyTag.class,criterionList);
		if(surveyTags != null && surveyTags.size()>0) {
			return surveyTags.get(0);
		}
		return null;
	}


	@Override
	public List<SurveyTag> findAllSurveyTag(){
		return baseDao.findAll(SurveyTag.class);
	}


	@Override
	public List<SurveyTag> findSurveyTagListByType(TagType type){
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("tagType", type));
		return baseDao.findByCriterion(SurveyTag.class,criterionList);
	}


	@Override
	public List<SurveyTag> findSurveyTagListByTypeAndLevel(TagType type,int level){
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("tagType", type));
		criterionList.add(Restrictions.eq("level", level));
		return baseDao.findByCriterion(SurveyTag.class,criterionList);
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public SurveyTag findSurveyTagByNameAndTypeAndLevel(String name, TagType type, int level) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		if(StringUtil.isNotEmpty(name)) {
			criterionList.add(Restrictions.eq("name", name));
		}else {
			return null;
		}
		if(type != null) {
			criterionList.add(Restrictions.eq("tagType", type));
		}else {
			return null;
		}
		criterionList.add(Restrictions.eq("level", level));
		List<SurveyTag> surveyTags = baseDao.findByCriterion(SurveyTag.class,criterionList);
		if(surveyTags != null && surveyTags.size()>0) {
			return surveyTags.get(0);
		}
		return null;
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<SurveyTag> findSurveyTagListByParentId(long tagId) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("parentId", tagId));
		return baseDao.findByCriterion(SurveyTag.class,criterionList);
	}

	@Override
	public void getSurveyTagsFromCMS() {
		cmsDao.findSurveyTagsFromCMS();
	}
}
