package com.bcxin.survey.service.wechat;

import com.bcxin.survey.dao.report.BaseDao;
import com.bcxin.survey.domain.wechat.AccessToken;
import com.bcxin.survey.enums.report.BillMsgType;
import com.bcxin.survey.utils.GlobalResources;
import com.bcxin.survey.utils.StringUtil;
import com.bcxin.survey.wechat.utils.WeixinUtil;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
@Transactional
public class AccessTokenServiceImpl implements AccessTokenService {

	@Autowired
	private BaseDao baseDao;

	@Override
	public boolean saveOrUpdate(AccessToken accessToken){
		boolean flag = true;
		try {
			if(accessToken != null){
				accessToken.setUpdateOn(new Date());				
				baseDao.saveOrUpdate(accessToken);
			}
		} catch(Exception e) {
			flag = false;
		}
		return flag;
	}

	@Override
	public AccessToken getAccessToken(){
		AccessToken accessToken = null;
		List<Criterion> criterions = new ArrayList<Criterion>();
		criterions.add(Restrictions.eq("type", BillMsgType.AccessToken));
		List<AccessToken> tokens = baseDao.findByCriterionForPage(AccessToken.class, criterions, null, Order.desc("updateOn"));
		if(tokens.size() > 0){
			accessToken = tokens.get(0);
			if((accessToken.getUpdateOn().getTime()+accessToken.getExpiresIn()*1000)<System.currentTimeMillis()) {
				accessToken = null;
			}
		}

		if(accessToken == null){
			accessToken = WeixinUtil.getAccessToken(GlobalResources.APPID,GlobalResources.APPSECRET);
			accessToken.setType(BillMsgType.AccessToken);
			saveOrUpdate(accessToken);
		}
		return accessToken;
	}

	@Override
	public String getJsapiTicket(){
		String jsapiTicket = "";
		AccessToken accessToken = null;
		List<Criterion> criterions = new ArrayList<Criterion>();
		criterions.add(Restrictions.eq("type", BillMsgType.JsapiTicket));
		List<AccessToken> tokens = baseDao.findByCriterionForPage(AccessToken.class, criterions, null, Order.desc("updateOn"));
		if(tokens.size() > 0){
			accessToken = tokens.get(0);
			if((accessToken.getUpdateOn().getTime()+accessToken.getExpiresIn()*1000)<System.currentTimeMillis()) {
				accessToken = null;
			}else {
				jsapiTicket = accessToken.getToken();
			}
		}

		if(accessToken == null){
			accessToken = WeixinUtil.getjsapi_ticket(getAccessToken());
			accessToken.setType(BillMsgType.JsapiTicket);
			saveOrUpdate(accessToken);
			jsapiTicket = accessToken.getToken();
		}
		return jsapiTicket;
	}

	@Override
	public void getJsApiConfig(ModelAndView view,HttpServletRequest request){
		String jsapi_ticket= getJsapiTicket();
		String url = GlobalResources.WEB_URL+request.getServletPath();
		System.out.println(request.getQueryString());
		if(StringUtil.isNotEmpty(request.getQueryString())) {
			url = url + "?" + request.getQueryString();
		}
		System.out.println(url);
		String noncestr = StringUtil.randomString(16);
		String timestamp = String.valueOf(System.currentTimeMillis() / 1000);
		String sign = WeixinUtil.getJSSDKSign(jsapi_ticket, noncestr, timestamp, url);
		view.addObject("appid",GlobalResources.APPID);
		view.addObject("url",url);
		view.addObject("noncestr",noncestr);
		view.addObject("timestamp",timestamp);
		view.addObject("sign",sign);
		
	}
}
