package com.bcxin.survey.enums.report;

/**
 * 任务状态
 * 新旧状态对照
 * 未完成 --> 待分配
 * 进行中 --> 已接受
 * 已完成 --> 已完成
 * 任务关闭 --> 结束
 * 已分配 --> 未接受
 * @author luopeng
 *
 */
public enum TaskStatus {

    UN_DISTRI("100","待分配"),
    UN_ACCEPT("101","未接受"),
    ACCEPT("102","已接受"),
    REFUSE("103","已拒绝"),
    FINISH("104","已完成"),
    CLOSE("105","结束");

    private String key;
    private String alias;

    TaskStatus(String key,String alias){
        this.key=key;
        this.alias=alias;
    }

    public String getKey(){
        return this.key;
    }

    public String getAlias(){
        return this.alias;
    }

    public String getName(){return this.alias;}

    public static String getAlias(String key){
        for(TaskStatus e : TaskStatus.values()){
            if(e.getKey().equals(key)){
                return e.getAlias();
            }
        }
        return "";
    }

//	UNDEFINE{public String getValue(){return "0";} public String getName(){return "未定义";}},
//
//	NON{public String getValue(){return "1";} public String getName(){return "未完成";}},
//
//	CONTINUE{public String getValue(){return "2";} public String getName(){return "进行中";}},
//
//	COMPLETE {public String getValue(){return "3";} public String getName(){return "已完成";}},
//
//	CLOSE {public String getValue(){return "4";} public String getName(){return "任务关闭";}},
//
//	ASSIGNED {public String getValue(){return "5";} public String getName(){return "已分配";}};
//
//    public abstract String getValue();
//
//    public abstract String getName();
//
//    public static TaskStatus convert_value(String value){
//    	if ( "1".equals(value) ) {
//    		return TaskStatus.NON;
//    	} else if ("2".equals(value)) {
//    		return TaskStatus.CONTINUE;
//    	} else if ("3".equals(value)) {
//    		return TaskStatus.COMPLETE;
//    	} else if ("4".equals(value)) {
//    		return TaskStatus.CLOSE;
//    	} else if ("5".equals(value)) {
//    		return TaskStatus.ASSIGNED;
//    	}
//    	return null;
//    }
//
//    public static TaskStatus convertName(String name){
//    	if ( "NON".equals(name) ) {
//    		return TaskStatus.NON;
//    	} else if ("CONTINUE".equals(name)) {
//    		return TaskStatus.CONTINUE;
//    	} else if ("COMPLETE".equals(name)) {
//    		return TaskStatus.COMPLETE;
//    	} else if ("CLOSE".equals(name)) {
//    		return TaskStatus.CLOSE;
//    	}else if ("ASSIGNED".equals(name)) {
//    		return TaskStatus.ASSIGNED;
//    	}
//    	return null;
//    }
}
