package com.bcxin.survey.domain.activity;

import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;


import com.bcxin.survey.domain.BaseBean;

import javax.persistence.*;

/**
 * 活动所属的场馆
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_Activity_Venue")
@Inheritance(strategy = InheritanceType.JOINED)
@DynamicInsert(true)
@DynamicUpdate(true)
public class ActivityVenue extends BaseBean {

	private static final long serialVersionUID = 1L;

	@ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "activity_id")
	private Activity activity;
	
	@ManyToOne(targetEntity = Venue.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "venue_id")
	private Venue venue;

	public Activity getActivity() {
		return activity;
	}

	public void setActivity(Activity activity) {
		this.activity = activity;
	}

	public Venue getVenue() {
		return venue;
	}

	public void setVenue(Venue venue) {
		this.venue = venue;
	}
	
}