package com.bcxin.risk.sys;

import com.bcxin.risk.common.domain.Dict;
import com.bcxin.risk.common.util.ConfigUtil;
import com.bcxin.risk.report.material.domain.MaterialFormOption;
import com.bcxin.risk.spring.SpringContextHolder;
import lombok.extern.slf4j.Slf4j;

import java.util.Collection;

/**
 * 系统基础信息相关的工具类
 * @author luopeng
 */
public class SysBasicUtil {

	private static SysDictUtil sysDictUtil = SpringContextHolder.getBean(SysDictUtil.class);

	private static SysMaterialOptionUtil sysMaterialOptionUtil = SpringContextHolder.getBean(SysMaterialOptionUtil.class);


	/**字典相关***/
	public static String getDictLabel(String value, String type, String defaultValue){
		return sysDictUtil.getDictLabel(value,type,defaultValue);
	}


	public static String getDictValue(String label, String type, String defaultLabel){
		return sysDictUtil.getDictLabel(label,type,defaultLabel);
	}

	public static Collection<Dict> getDictList(String type){
		return sysDictUtil.getDictList(type);
	}

	public static String getDictListJson(String type){
		return sysDictUtil.getDictListJson(type);
	}

	/*** option相关 ***/
	public static String getOptionLabel(String value, String type, String defaultValue){
		return sysMaterialOptionUtil.getOptionLabel(value,type,defaultValue);
	}

	public static Collection<MaterialFormOption> getOptionList(String type){
		return sysMaterialOptionUtil.getOptionList(type);
	}

	public static String getConfig(String key){
		return ConfigUtil.getValue(key);
	}


}
