<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <base href="@@baseUrl">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="renderer" content="webkit">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <title>合作伙伴管理系统</title>
    <link rel="stylesheet" href="/static/weixin/css/public.css">
    <link rel="stylesheet" href="/static/weixin/css/basic.css">
    <link rel="stylesheet" href="/static/weixin/css/wechat_add_new.css">
    <link rel="stylesheet" href="/static/weixin/css/new_basic.css">
    <link rel="stylesheet" href="/static/weixin/css/management_system.css?v=1.0.6">
    <script src="/static/weixin/js/flexible.js"></script>
    <script type="text/javascript">
        var weixin_login_distribution_level = "${p.weixin_login_distribution_level}";
        var weixin_login_company_type = "${p.weixin_login_company_type}";

        /**
         * 转换数字
         * @param val
         * @returns {*}
         */
        function formatNumeric(val){
            if(val!=null){
                return val.toFixed(2);
            }else{
                return "0.00";
            }
        }

    </script>

</head>
<body id="contain">
<div class="contain">
    <div class="bai-head">
        <span>合作伙伴管理系统</span>
        <%--<a href="javascript:void(0);" class="left">--%>
            <%--<img src="/static/weixin/images/head-left.png"/>--%>
        <%--</a>--%>
    </div>
    <div id="wrapper">
        <div class="sdf" id="scroller">

            <!--新的替换start-->
            <div class="management-system">
                <div class="system-header">
                    <h2>${weixin_user.companyName}</h2>
                    <a href="/weixin/account/index">
                        我的信息
                    </a>
                </div>
                <div class="system-content">
                    <div class="s-content">
                        <a <c:if test="${displayShare eq 'yes'}">href="/weixin/share/shareIndex" </c:if>
                           <c:if test="${displayShare eq 'no'}">style="opacity:0.3"  </c:if>
                        >
                            <img src="/static/weixin/images/system-d1.png" alt="">
                            <span>我的推广</span>
                        </a>
                    </div>
                    <div class="s-content">
                        <a <c:if test="${display eq 'yes'}">href="/weixin/partner/list" </c:if>
                           <c:if test="${display eq 'no'}">style="opacity:0.3"  </c:if>
                        >
                            <img src="/static/weixin/images/system-d2.png" alt="">
                            <span>下级管理</span>
                        </a>
                    </div>
                    <div class="s-content">
                        <a href="/weixin/billNewPage/index">
                            <img src="/static/weixin/images/system-d3.png" alt="">
                            <span>收入管理</span>
                        </a>
                    </div>
                </div>
                <div class="system-money">
                    <div class="money-content-a1">
                        <div class="a1-left">
                            <h3>累积总收入：<br/><span id="currAmountTotal">￥0.00</span></h3>
                            <p>共<span id="totalCount">0</span>单</p>
                        </div>
                        <div class="a1-right">
                            <c:if test="${p.weixin_login_company_type!=4}">
                            <div class="right-cont">
                                <p>下级收入</p>
                                <span id="lowerAmountTotal">￥0.00</span>
                            </div>
                            </c:if>
                            <c:if test="${p.weixin_login_distribution_level eq '1' || p.weixin_login_company_type eq '4'}">
                            <div class="right-cont">
                                <p>已结算</p>
                                <span id="settleAmount">￥0.00</span>
                            </div>
                            </c:if>
                            <c:if test="${p.weixin_login_company_type!=4}">
                            <div class="right-cont">
                                <p>净收入</p>
                                <span id="currAmount">￥0.00</span>
                            </div>
                            </c:if>

                            <c:if test="${p.weixin_login_distribution_level eq '1' || p.weixin_login_company_type eq '4'}">
                            <div class="right-cont">
                                <p>未结算</p>
                                <span id="noSettleAmount">￥0.00</span>
                            </div>
                            </c:if>
                        </div>
                    </div>
                    <c:if test="${p.weixin_login_company_type!=4}">
                    <div class="money-content-a2" >
                        <div class="a2-content">
                            <h2>本月总收入</h2>
                            <p id="currAmountTotalMonth">￥0.00</p>
                            <span>共<em id="totalCountMonth">0</em>单</span>
                        </div>
                        <div class="a2-content">
                            <h2>下级收入</h2>
                            <p id="lowerAmountTotalMonth">￥0.00</p>
                            <span>共<em id="lowerTotalCountMonth">0</em>单</span>
                        </div>
                        <div class="a2-content">
                            <h2>净收入</h2>
                            <p id="currAmountMonth">￥0.00</p>
                            <span>共<em id="currTotalCountMonth">0</em>单</span>
                        </div>
                    </div>
                    </c:if>
                </div>
                <div class="system-footer">
                    <span>最近账单</span>
                    <a href="javascript:void(0);" id="getAll">全部</a>
                </div>
            </div>
            <!--新的替换end-->

            <ul class="home-bill" id="thelist">
                <%--<li>--%>
                    <%--<div class="bill-head">--%>
                        <%--<span>订单号：<em>98000000000000000</em></span>--%>
                        <%--<a href="javascript:;">查看详情 ></a>--%>
                    <%--</div>--%>
                    <%--<div class="bill-text">--%>
                        <%--<p class="an">--%>
                            <%--<span>--%>
                                <%--安保无忧全年意外险计划四安保无忧全年意外险计划四安保无忧全年意外险计划四--%>
                            <%--</span>--%>
                        <%--</p>--%>
                        <%--<p class="jie">--%>
                            <%--<span>已结算</span>--%>
                            <%--<i>来源: <em>本级名称</em></i>--%>
                        <%--</p>--%>
                        <%--<p class="bill-time">--%>
                            <%--支付时间：2018-04-28 16:16:16--%>
                        <%--</p>--%>
                    <%--</div>--%>
                    <%--<div class="bill-footer">--%>
                        <%--<div class="footer-cont">--%>
                            <%--<p>订单金额：<span>￥5000.00</span></p>--%>
                            <%--<p>下级收入：<span>￥500.00</span></p>--%>
                        <%--</div>--%>
                        <%--<div class="footer-cont">--%>
                            <%--<p>订单收入：<span>￥5000.00</span></p>--%>
                            <%--<p>净收入：<span>￥500.00</span></p>--%>
                        <%--</div>--%>
                    <%--</div>--%>
                <%--</li>--%>
            </ul>
            <div id="pullUp">
                <span class="pullUpLabel">上拉加载更多...</span>
            </div>
            <p id="ert"></p>
        </div>
    </div>
</div>
<script src="/static/weixin/js/jquery-1.8.3.min.js"></script>
<script src="/static/weixin/common/layer_mobile/layer.js"></script>
<link rel="stylesheet" href="/static/weixin/common/layer_mobile/need/right.css">
<script type="text/javascript" src="/static/weixin/js/iscroll.js"></script>
<%--<script type="text/javascript" src="/static/weixin/js/index_scroll_content.js"></script>--%>
<script type="text/javascript" src="/static/weixin/js/g.js?v=1.0.6"></script>
<script type="text/javascript">
    var myScroll, pullUpEl, pullUpOffset;
    var p = { limit: 5, offset: 0 };

    $(document).ready(function(){
        bindData();
        getData();
        //绑定全部事件
        $("#getAll").click(function(){
            window.location.href="/weixin/billNewPage/index";
            // p={ limit: 9999999, offset: 0 };
            // var el = document.getElementById('thelist');
            // $(el).empty();
            // getData();
        });
    });

    /**
     * 绑定数据
     */
    function bindData(){
        var currAmountTotal=number_format('${billOrderTotal.currAmountTotal}',2,'.',',');
        $("#currAmountTotal").html('￥'+currAmountTotal);

        var totalCount='${billOrderTotal.totalCount}';
        $("#totalCount").html(totalCount);

        var lowerAmountTotal=number_format('${billOrderTotal.lowerAmountTotal}',2,'.',',');
        $("#lowerAmountTotal").html('￥'+lowerAmountTotal);

        var settleAmount=number_format('${billOrderTotal.settleAmount}',2,'.',',');
        $("#settleAmount").html('￥'+settleAmount);

        var currAmount=number_format('${billOrderTotal.currAmount}',2,'.',',');
        $("#currAmount").html('￥'+currAmount);

        var noSettleAmount=number_format('${billOrderTotal.noSettleAmount}',2,'.',',');
        $("#noSettleAmount").html('￥'+noSettleAmount);

        //本月收入
        var currAmountTotalMonth=number_format('${billOrderTotalMonth.currAmountTotal}',2,'.',',');
        $("#currAmountTotalMonth").html('￥'+currAmountTotalMonth);

        var lowerAmountTotalMonth=number_format('${billOrderTotalMonth.lowerAmountTotal}',2,'.',',');
        $("#lowerAmountTotalMonth").html('￥'+lowerAmountTotalMonth);

        var currAmountMonth=number_format('${billOrderTotalMonth.currAmount}',2,'.',',');
        $("#currAmountMonth").html('￥'+currAmountMonth);

        var totalCountMonth='${billOrderTotalMonth.totalCount}';
        $("#totalCountMonth").html(totalCountMonth);

        var lowerTotalCountMonth='${billOrderTotalMonth.lowerTotalCount}';
        $("#lowerTotalCountMonth").html(lowerTotalCountMonth);

        var currTotalCountMonth='${billOrderTotalMonth.currTotalCount}';
        $("#currTotalCountMonth").html(currTotalCountMonth);
    }

    /**
     * 获取数据
     */
    function getData(){
        layer.open({type:2});
        g_ajax("/weixin/billNew/getBillOrderList",p ,function(json){
            var el, li;
            var rows = json.rows;
            el = document.getElementById('thelist');
            if(rows.length==0) { //长度为空，或者小于limit条数，说明是已经到最后了
                layer.closeAll();
                $("#pullUp").hide();
                $("#ert").text('数据已经加载完了！').show();
                return;
            }else{
                p.offset += p.limit;
            }
            for(var i in rows){
                var monthStatus = rows[i].monthStatus=="0"?"未结算":"已结算";
                // if(weixin_login_distribution_level=="2" || weixin_login_distribution_level=="3" ){
                //     monthStatus = "";
                // }

                li = document.createElement('li');
                var html =
                    '<div class="bill-head"><span>单号：'+ rows[i].orderNo + '</span><a href="/weixin/billNewPage/detail/'+rows[i].orderId+'">点击查看详情 &gt;</a></div>'
                    + '<div class="bill-text"><p class="an"><span>'+rows[i].projectName+'</span></p>';

                //等级为1或者资源方才有结算状态
                if(weixin_login_distribution_level=='1' || weixin_login_company_type=='4'){
                    html+= '<p class="jie"><span>'+monthStatus+'</span>';
                }else{
                    html+= '<p class="jie">';
                }
                //保险产品
                if(rows[i].productType=='6' && weixin_login_company_type =='2'){
                    html+='<i>来源: <em>'+formatterStr( rows[i].sourceCompanyName )+'</em></i>';
                }

                    html+='</p>'
                    + '<p class="bill-time">支付时间：'+ formatterStr( rows[i].payDate ) +'</p>'
                    + '</div>'
                    + '<div class="bill-footer">'
                    + '<div class="footer-cont">'
                    + '<p>订单金额：<span>￥'+ number_format(rows[i].orderAmount,2,'.',',') +'</span></p>';
                if(weixin_login_company_type!='4') {
                    html+='<p>下级收入：<span>￥' + number_format(rows[i].lowerOrderAmount, 2, '.', ',') + '</span></p>';
                }
                html+= '</div>'
                    + '<div class="footer-cont">'
                    + '<p>订单收入：<span>￥'+ number_format(rows[i].currOrderAmount,2,'.',',') +'</span></p>';
                if(weixin_login_company_type!='4') {
                    html+='<p>净收入：<span>￥' + number_format(rows[i].currAmount, 2, '.', ',') + '</span></p>';
                }
                html+= '</div>'
                    + '</div>';
                li.innerHTML=html;
                el.appendChild(li, el.childNodes[0]);
            }
            layer.closeAll();
        },false);
    }

    /**
     * 初始化iScroll控件
     */
    function loaded() {

        pullUpEl = document.getElementById('pullUp');
        pullUpOffset = pullUpEl.offsetHeight;

        myScroll = new iScroll('wrapper', {
            scrollbarClass: 'myScrollbar', /* 重要样式 */
            scrollbars: true,
            mouseWheel: true,//允许滑轮滚动
            useTransition: false, /* 此属性不知用意，本人从true改为false 动画 */
            onRefresh: function () {
                if (pullUpEl.className.match('loading')) {
                    pullUpEl.className = '';
                    pullUpEl.querySelector('.pullUpLabel').innerHTML = '上拉加载更多...';
                }
            },
            onScrollMove: function () {
                if (this.y < (this.maxScrollY - 55) && !pullUpEl.className.match('flip')) {
                    pullUpEl.className = 'flip';
                    pullUpEl.querySelector('.pullUpLabel').innerHTML = '松手开始更新...';
                    this.maxScrollY = this.maxScrollY;
                } else if (this.y > (this.maxScrollY + 55) && pullUpEl.className.match('flip')) {
                    pullUpEl.className = '';
                    pullUpEl.querySelector('.pullUpLabel').innerHTML = '上拉加载更多...';
                    this.maxScrollY = pullUpOffset;
                }
            },
            onScrollEnd: function () {
                if (pullUpEl.className.match('flip')) {
                    pullUpEl.className = 'loading';
                    pullUpEl.querySelector('.pullUpLabel').innerHTML = '正在加载...';
                    pullUpAction();	// Execute custom function (ajax call?)
                }
            }
        });

        setTimeout(function () { document.getElementById('wrapper').style.left = '0'; }, 800);
    }

    function pullUpAction () {
        getData();
        myScroll.refresh();		// 数据加载完成后，调用界面更新方法 Remember to refresh when contents are loaded (ie: on ajax completion)
    }

    //初始化绑定iScroll控件
    document.addEventListener('touchmove', function (e) { e.preventDefault(); }, false);
    document.addEventListener('DOMContentLoaded', loaded, false);

    /**
     * 格式化字符串
     * @param val
     * @returns {*}
     */
    function formatterStr(val) {
        if(val!=undefined && val!=null){
            return val;
        }
        return "--";
    }
    
</script>
</body>
</html>