<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="renderer" content="webkit">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <script src="/static/weixin/js/flexible.js"></script>
    <link rel="stylesheet" href="/static/weixin/css/wechat_add_new.css">
    <link rel="stylesheet" href="/static/weixin/css/public.css">
    <link rel="stylesheet" href="/static/weixin/css/basic.css">
    <title>展会详情</title>
    <style>
        #wrapper {
            overflow: auto;
        }
        .zeng-exhibition ul.exhibition-cont li input.input-tiao {
            background: url(../images/left.png) no-repeat 95% center;
            background-size: 0.18667rem 0.34667rem;
        }
        .specialText{
            white-space: normal !important;
            word-break: break-all !important;
            text-overflow: unset !important;
            line-height: 0.6rem !important;
            padding-top: 0.3rem !important;
            padding-bottom: 0.3rem !important;
            text-align: right !important;
        }
    </style>
</head>
<body id="contain">
<div class="contain">
    <div class="bai-head">
        <span>展会详情</span>
        <a href="/weixin/activity/activityListOnline" class="left">
            <img src="/static/weixin/activity/images/head-left.png"/>
        </a>
        <i class="she">设置</i>
        <div class="she-content">
            <ul>
                <li>
                    <a href="/weixin/activity/activityUpd?id=${activity.id}">修改展会</a>
                </li>
                <li>
                    <c:if test="${activity.status eq '1'}" >
                        <a href="javascript:;" id="dong" onclick="tijiao(${activity.status})">下架展会</a>
                    </c:if>
                    <c:if test="${activity.status eq '0'}" >
                        <a href="javascript:;" id="dong" onclick="tijiao(${activity.status})">上架展会</a>
                    </c:if>
                </li>
            </ul>
        </div>
    </div>
    <div id="wrapper">
    <div  class="show-details">
        <h2>展会信息</h2>
        <ul class="details-information">
            <li>
                <input type="hidden" name="id" id="id" value="${activity.id}">
                <span>展会活动名称</span>
                <p class="specialText">${activity.activity_name}</p>
            </li>
            <li>
                <span>状态</span>
                <span>状态</span>
                <c:if test="${activity.status eq '1'}" >
                    <p>已上架</p>
                </c:if>
                <c:if test="${activity.status eq '0'}" >
                    <p>已下架</p>
                </c:if>
            </li>
            <li>
                <span>开始时间</span>
                <p><fmt:formatDate pattern="yyyy-MM-dd"
                                   value="${activity.start_time}" /></p>
            </li>
            <li>
                <span>结束时间</span>
                <p id="end_time"><fmt:formatDate pattern="yyyy-MM-dd"
                                                 value="${activity.end_time}" /></p>
            </li>
            <li>
                <span>所在城市</span>
                <p id="city"></p>
                <input type="hidden" name="province" value="${activity.province}" id="s-province">
                <input type="hidden" name="city" value="${activity.city}" id="s-city">
                <input type="hidden" name="district" value="${activity.district}" id="s-area">
            </li>
            <li>
                <span>具体地址</span>
                <p class="specialText">${activity.address}</p>
            </li>
            <li>
                <%-- 跳转到选择展厅展位页面 --%>
                <span>展厅展位</span>
                <p id="exhibitionPosCnt" class="detailText">已设置展位${activity.exhibitionPosCnt}个</p>
            </li>
        </ul>
    </div>
    <div class="show-details">
        <h2>保险信息</h2>
        <ul class="details-information">
            <li>
                <a class="wed-ert" onclick="changeProduct()">
                    <c:if test="${ empty  num}"><span>选择保险</span></c:if>
                    <c:if test="${not empty  num}"><span>已选择 ${num}款 保险</span></c:if>
                </a>
            </li>
        </ul>
    </div>
        <div style="padding-bottom:10.13333rem"></div>
    </div>
</div>

<div class="pro-steps assigned-steps">
    <div class="steps">
        <c:if test="${activity.status eq '1'}" >
            <button class="xia" onclick="share()">生成推广链接</button>
        </c:if>
        <button onclick="toExhibitionCase()">展位投保情况</button>
    </div>
</div>

<!--白色蒙版-->
<div class="white-mask"></div>

<!--蒙版-->
<div class="mask_block"></div>

<!--分享前的弹窗提示-->
<div class="empty_booth lm_hall_detailed">
    <div class="hall_content">
        <img src="/static/weixin/images/lm_Promotion-s4.png">
        <p>分享前请选择适合该活动的保险产品！</p>
    </div>
    <div class="hall_footer_one">
        <span class="cancel">取消</span>
        <span class="sure">确定</span>
    </div>
</div>

<script src="/static/weixin/activity/js/jquery-1.8.3.min.js"></script>

<script src="/static/weixin/common/layer_mobile/layer.js"></script>
<link rel="stylesheet" href="/static/weixin/common/layer_mobile/need/right.css">
<script src="${ctxwxsta}/js/g.js"></script>
<script>
    $('.bai-head i.she').click(function () {
        if($('.bai-head .she-content').hasClass('active')){
            $('.bai-head .she-content').removeClass('active');
            $('.white-mask').hide();
        }else{
            $('.bai-head .she-content').addClass('active');
            $('.white-mask').show();
        }
    });
    $('.white-mask').click(function () {
        $('.bai-head .she-content').removeClass('active');
        $('.white-mask').hide();
    });
    $('.assigned-steps .steps button').click(function () {
        $('.bai-head .she-content').removeClass('active');
        $('.white-mask').hide();
    });
//    $('.assigned-steps .steps button.xia').click(function () {
////        $('.empty_booth').show();
////        $('.mask_block').show();
//        share();
//    });

    $('.empty_booth span.cancel').click(function () {
        $('.empty_booth').hide();
        $('.mask_block').hide();
    });
    $('.empty_booth span.sure').click(function () {
        $('.empty_booth').hide();
        $('.mask_block').hide();
    });

    function share() {
        var num ='${num}';
        if(num==''){
            layer.open({
                content: '分享前请选择适合该活动的保险产品！'
            });
        }else{
            var productId='${productIds}';
            window.location.href="/weixin/activity/activityErweima?id="+$("#id").val()+"&productIds="+productId;
        }
    }

    function submit(id, flag){
        $.ajax({
            type: 'POST',
            url: "/weixin/activity/saveActivityStatus",
            data:{id:id,status:flag},
            dataType:"json",
            async: false,
            success: function(data){
                if(data.success){
                    if(flag==1){
                        window.location.href="/weixin/activity/activityListOnline";
                    }else{
                        window.location.href="/weixin/activity/activityListOffline";
                    }
                }else{
                    layer.open({content:"操作失败",btn: '我知道了'});
                }
            }
        });
    }

    function  changeProduct() {
        window.location.href="/weixin/share/activityShareProduct?activityId=${activity.id}";

    }

    var   city=$("#s-province").val()+$("#s-city").val()+$("#s-area").val()+"";
    if(city!=''){
        $("#city").html(g_getRegion($("#s-province").val()).province+" "+g_getRegion($("#s-city").val()).citytype+" "+g_getRegion($("#s-area").val()).city);
    }

    /**
     * 跳转到展会情况
     */
    function toExhibitionCase(){
        window.location.href="/weixin/exhibition/exhibition-detail-view?activityId=${activity.id}&mark=detail";
    }


    function  tijiao(status){
        var  flag=status;
        var  id=$("#id").val();
        if(status==1){
            flag=0;
            //判断活动时间是否为已经过期，如果已经过期自动提示
            console.log(Gdate.getDateDiff(Gdate.curtime(),$("#end_time").text(),"day"));
            if(Gdate.getDateDiff(Gdate.curtime(),$("#end_time").text(),"day")>=0){
                layer.open({
                    content: '活动尚未结束，是否确定下架活动？' ,btn: ['确定', '取消']
                    ,yes: function(index){
                        layer.close(index);
                        submit(id, flag);
                    }
                });
            }else{
                submit(id, flag);
            }
        }
        if(status==0){
            flag=1;
            submit(id, flag)
        }
    }
</script>
</body>
</html>