package com.bcxin.wechat.weixin.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.wechat.weixin.service.WeiXinService;
import com.bcxin.wechat.weixin.util.AccessToken;
import com.bcxin.wechat.weixin.util.ConstantWeiXin;
import com.bcxin.wechat.weixin.util.WeixinUtil;
import com.bcxin.wechat.weixin.util.menu.Menu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 微信业务处理
 * 2017-8-16
 */
@Service
@Transactional
public class WeiXinServiceImpl implements WeiXinService {


    public static Logger logger = LoggerFactory.getLogger(WeiXinServiceImpl.class);

    @Override
    public String getOppenId(String code) {
        String url = ConstantWeiXin.GET_OPPPENID.replace("CORPID", ConstantWeiXin.CORPID).replace("SECRET", ConstantWeiXin.SECRET).replace("CODE", code);
        JSONObject json = WeixinUtil.httpRequest(url, "GET", null);
        if (json != null) {
            System.out.printf("获取getOppenId" + json.toString());
//            logger.info("获取getOppenId"+json.toString());
            return json.get("openid").toString();
        }
        return null;
    }

    @Override
    public AccessToken getAccessToken() {
        String url = ConstantWeiXin.GET_TOKEN.replace("CORPID", ConstantWeiXin.CORPID).replace("SECRET", ConstantWeiXin.SECRET);
        JSONObject json = WeixinUtil.httpRequest(url, "GET", null);
        AccessToken accessToken = null;
        if (json != null) {
            logger.info("获取getAccessToken" + json.toString());
            accessToken = new AccessToken();
            accessToken.setToken(json.getString("access_token"));
            accessToken.setExpiresIn(json.getInteger("expires_in"));
            return accessToken;
        }
        return null;
    }

    @Override
    public String createMenu(Menu menu, String token) {
        String url = ConstantWeiXin.CREATE_MENU.replace("ACCESS_TOKEN", token);
        String jsonMenu = JSONObject.toJSONString(menu);
        JSONObject json = WeixinUtil.httpRequest(url, "POST", jsonMenu);
        if (json != null) {
            logger.info("createMenu" + json.toString());
            if ("0".equals(json.get("errcode").toString())) {
                return "success";
            }
        }
        return "fail";
    }

    @Override
    public String getShortUrl(String token) {
        String url = ConstantWeiXin.URL_TO_SHORT.replace("ACCESS_TOKEN", token);
        JSONObject jsonUrl = new JSONObject();
        jsonUrl.put("access_token", token);
        jsonUrl.put("action", "long2short");
        jsonUrl.put("long_url", url);
        String jsonParam = JSONObject.toJSONString(jsonUrl);
        JSONObject json = WeixinUtil.httpRequest(url, "POST", jsonParam);
        if (json != null) {
            logger.info("getShortUrl" + json.toString());
            if ("0".equals(json.get("errcode").toString())) {
                return json.get("short_url").toString();
            }
        }
        return null;
    }

    /**
     * 创建群组
     *
     * @return 如{"group": { "id": 107, "name": "test" } }
     */
    @Override
    public String createTag(JSONObject jsonUrl, String token) {

        String url = ConstantWeiXin.CRATE_TAG.replace("ACCESS_TOKEN", token);
        String jsonParam = JSONObject.toJSONString(jsonUrl);
        try {
            JSONObject json = WeixinUtil.httpRequest(url, "POST", jsonParam);
            if (json != null) {
                logger.info("CRATE_TAG" + json.toString());
                //{"tag":{"id":102,"name":"运营"}}

                JSONObject j = JSONObject.parseObject(json.get("tag").toString());
                if (j != null) {
                    return j.get("id").toString();
                }

            }
        } catch (Exception ex) {
            return null;
        }
        return null;
    }

    @Override
    public String joinUsertoTag( String tagId, List<String> oppenIds, String token) {
        String url = ConstantWeiXin.JOIN_TAG_USER.replace("ACCESS_TOKEN", token);
        JSONObject json1 = new JSONObject();
        json1.put("tagid", tagId);
        int size = oppenIds.size();
        String[] arr = (String[]) oppenIds.toArray(new String[size]);
        json1.put("openid_list", arr);
//        POST数据格式：JSON
//        POST数据例子：
//        {
//            "openid_list" : [//粉丝列表
//            "ocYxcuAEy30bX0NXmGn4ypqx3tI0",
//                    "ocYxcuBt0mRugKZ7tGAHPnUaOW7Y"
//            ],
//            "tagid" : 134
//        }
        String jsonParam = json1.toJSONString();
        logger.info("JOIN_TAG_USER-START" + jsonParam);
        try {
            JSONObject json = WeixinUtil.httpRequest(url, "POST", jsonParam);
            logger.info("JOIN_TAG_USER-RESULT" + jsonParam);
            if (json != null) {
                logger.info("JOIN_TAG_USER" + json.toString());


                JSONObject j = JSONObject.parseObject(json.get("tag").toString());
                if (j != null) {
                    return j.toJSONString();
                }
            }
        } catch (Exception ex) {
            return null;
        }
        return null;
    }

    @Override
    public String createQrcode( String tagId, String token) {
        String url = ConstantWeiXin.QRCODE_CREATE.replace("ACCESS_TOKEN", token);
        //POST数据例子：{"action_name": "QR_LIMIT_SCENE", "action_info": {"scene": {"scene_id": 123}}}
        JSONObject  json1= new JSONObject();
        json1.put("scene_id",Integer.parseInt(tagId));
        JSONObject  json2= new JSONObject();
        json2.put("scene",json1);
        JSONObject  json= new JSONObject();
        json.put("action_name","QR_LIMIT_SCENE");
        json.put("action_info",json2);
        String jsonParam = json.toJSONString();
        try {
            JSONObject jsonResult = WeixinUtil.httpRequest(url, "POST", jsonParam);
            if (jsonResult != null) {
                //{"action_name": "QR_LIMIT_SCENE", "action_info": {"scene": {"scene_id": 123}}}
                logger.info("QRCODE_CREATE" + jsonResult.toString());
//                {"ticket":"gQH47joAAAAAAAAAASxodHRwOi8vd2VpeGluLnFxLmNvbS9xL2taZ2Z3TVRtNzJXV1Brb3ZhYmJJAAIEZ23sUwMEmm
//                    3sUw==","expire_seconds":60,"url":"http:\/\/weixin.qq.com\/q\/kZgfwMTm72WWPkovabbI"}

                if (jsonResult.getString("ticket") != null) {
                    return jsonResult.toJSONString();
                }


            }
        } catch (Exception ex) {
            return null;
        }

        return null;
    }


}
