package com.bcxin.wechat.weixin.process;


import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.wechat.tag.entity.WeiXinTag;
import com.bcxin.wechat.tag.service.WinXinTagService;
import com.bcxin.wechat.weixin.entity.ReceiveXmlEntity;
import com.bcxin.wechat.weixin.service.WeiXinService;
import com.bcxin.wechat.weixin.util.AccessToken;
import com.bcxin.wechat.weixin.util.ConstantWeiXin;
import com.bcxin.wechat.weixin.util.MessageUtil;
import com.bcxin.wechat.weixin.util.msg.Resp.Article;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 微信xml消息处理流程逻辑类
 *
 * @author 科帮网
 */
public class WechatProcess {


    /**
     * 解析处理xml、获取智能回复结果（通过图灵机器人api接口）
     *
     * @param xml 接收到的微信数据
     * @param weiXinService
     *@param winXinTagService @return 最终的解析结果（xml格式数据）
     */
    public String processWechatMag(String xml, WeiXinService weiXinService, WinXinTagService winXinTagService) {
        /** 解析xml数据 */
        ReceiveXmlEntity xmlEntity = new ReceiveXmlProcess().getMsgEntity(xml);

        /** 以文本消息为例，调用图灵机器人api接口，获取回复内容 */
        String result = "您好，欢迎关注百川信。百川信（北京）信息服务有限公司作为国内领先的数字安保解决方案与应用服务提供商，垂直于公共安全领域，聚焦安保应用场景数字化创新，旨在为行业监管单位、行业协会、从业单位、从业人员提供多维度、立体化的解决方案及信息化服务，助力安保行业实现数字化转型。欢迎致电客服热线 400-662-9696，了解更多服务。";
        if (MessageUtil.REQ_MESSAGE_TYPE_TEXT.endsWith(xmlEntity.getMsgType())) {

//            if("培训回执".equals(xmlEntity.getContent())){
//                result="http://www.baibaodun.cn:84/pxxtfront/huizhi/";
//                result = new FormatXmlProcess().formatXmlAnswer(xmlEntity.getFromUserName(), xmlEntity.getToUserName(), result);
//                return result;
//            }else{
            if("广西公安帐号配置".equals(xmlEntity.getContent())||"广西公安账号配置".equals(xmlEntity.getContent())){

                Article article=new Article();
                article.setDescription("公安机关帐号配置指导。"); //图文消息的描述
                article.setPicUrl("http://dfyyy.com/image/weixin.png"); //图文消息图片地址
                article.setTitle("【广西保安服务监管信息系统·操作指导】：公安机关帐号怎么配置？");  //图文消息标题
                article.setUrl("http://mp.weixin.qq.com/s?__biz=MzIzNzQ0Nzg1OA==&mid=100001045&idx=1&sn=0504870a1fc5965eb348e02ff4de0712&chksm=68c93ac85fbeb3de7a445a04c9fe4ae52a870a2200b302dfadaa106a352a0b097e2ad97189ed#rd");  //图文url链接
                result = new FormatXmlProcess().formatPiCtureXmlAnswer(xmlEntity.getFromUserName(), xmlEntity.getToUserName(), article);
                return result;
            } else if("陕西公安帐号配置".equals(xmlEntity.getContent())||"陕西公安账号配置".equals(xmlEntity.getContent())){
                Article article=new Article();
                article.setDescription("陕西公安帐号配置指导。"); //图文消息的描述
                article.setPicUrl("http://dfyyy.com/image/weixin.png"); //图文消息图片地址
                article.setTitle("【陕西保安服务监管信息系统·操作指导】：公安机关帐号怎么配置？");  //图文消息标题
                article.setUrl("http://mp.weixin.qq.com/s?__biz=MzIzNzQ0Nzg1OA==&mid=100001073&idx=1&sn=9c2e30810e7ee43b063a97ae77bcdda8&chksm=68c93aec5fbeb3fad49b072eb1a4afd92e92c9433d7a2bbc58b6c5615d60fe4f1fd7361557ca#rd");  //图文url链接
                result = new FormatXmlProcess().formatPiCtureXmlAnswer(xmlEntity.getFromUserName(), xmlEntity.getToUserName(), article);
                return result;
            }else if("宁夏".equals(xmlEntity.getContent())){
                result="<a href='http://www.baibaodun.cn:84/pxxtfront/huizhi/'>请点击本条信息填写“新版宁夏保安服务监管信息系统管理员（操作员）培训”参训回执</a>";
                result = new FormatXmlProcess().formatXmlAnswer(xmlEntity.getFromUserName(), xmlEntity.getToUserName(), result);
                return result;
            }else if("金融服务".equals(xmlEntity.getContent())){
                result="<a href='http://www.baibaodun.cn/h5/saas_jrfw.html'>百保盾企业金融服务</a>";
                result = new FormatXmlProcess().formatXmlAnswer(xmlEntity.getFromUserName(), xmlEntity.getToUserName(), result);
                return result;
            }else{
//                result="<a href='https://wpa1.qq.com/gAQ8dmBU?_type=wpa&qidian=true'>未找到相关内容，如需客服咨询请点击本条信息跳转在线客服功能</a>";
//                result = new FormatXmlProcess().formatXmlAnswer(xmlEntity.getFromUserName(), xmlEntity.getToUserName(),result);
                result = new FormatXmlProcess().formatAnswerToCustomerService(xmlEntity.getFromUserName(), xmlEntity.getToUserName());
                return result;
           }
        }

        if (MessageUtil.REQ_MESSAGE_TYPE_EVENT.endsWith(xmlEntity.getMsgType())) {

            WeiXinTag tag=null;
            if(StringUtils.isNotEmpty(xmlEntity.getTicket())){
                //场景值是否存在
                tag= winXinTagService.selectOne(new EntityWrapper().addFilter("ticket={0}", xmlEntity.getTicket()));
                if(tag!=null){
                    result=tag.getMsgContent();//推送信息
                }
            }
            if (xmlEntity.getEvent().equals(MessageUtil.EVENT_TYPE_SUBSCRIBE)){
                //扫描判断是否有场景  ，再判断用户是否已经关注了  推送对应信息
                if(tag!=null){
                    List<String> list= new ArrayList<>();
                    list.add(xmlEntity.getFromUserName());
                    AccessToken at = weiXinService.getAccessToken();
                    //给用户打标签

                    weiXinService.joinUsertoTag(tag.getTagId(),list,at.getToken());//本地方法，根据url提交json内容
                }
//                result="guanzhu";
                //打标签
                result = new FormatXmlProcess().formatXmlAnswer(xmlEntity.getFromUserName(), xmlEntity.getToUserName(), result);
                return result;
            }
            if (xmlEntity.getEvent().equals("SCAN")){
                result = new FormatXmlProcess().formatXmlAnswer(xmlEntity.getFromUserName(), xmlEntity.getToUserName(), result);
                return result;
            }
            if (xmlEntity.getEvent().equals("CLICK")){
                if(ConstantWeiXin.ONLINE_SERVICE.equals(xmlEntity.getEventKey())) {
                    result = "百川信服务号现已接入微信在线客服服务，请直接在当前对话中输入您想咨询的问题。也可致电4006629696客服热线与我们联系，谢谢";
                    result = new FormatXmlProcess().formatXmlAnswer(xmlEntity.getFromUserName(), xmlEntity.getToUserName(), result);
                    return result;
                }
            }

        }
        return null;
        /** 此时，如果用户输入的是“你好”，在经过上面的过程之后，result为“你也好”类似的内容
         *  因为最终回复给微信的也是xml格式的数据，所有需要将其封装为文本类型返回消息
         * */

    }
}
