package com.bcxin.wechat.weixin.process;

import com.bcxin.wechat.weixin.util.msg.Resp.Article;

import java.util.Date;
/**
 * 封装最终的xml格式结果
 * @author 科帮网
 *
 */
public class FormatXmlProcess {
	/**
	 * 封装文字类的返回消息
	 * @param to
	 * @param from
	 * @param content
	 * @return
	 */
	public String formatXmlAnswer(String to, String from, String content) {
		StringBuffer sb = new StringBuffer();
		Date date = new Date();
		sb.append("<xml><ToUserName><![CDATA[");
		sb.append(to);
		sb.append("]]></ToUserName><FromUserName><![CDATA[");
		sb.append(from);
		sb.append("]]></FromUserName><CreateTime>");
		sb.append(date.getTime());
		sb.append("</CreateTime><MsgType><![CDATA[text]]></MsgType><Content><![CDATA[");
		sb.append(content);
		sb.append("]]></Content><FuncFlag>0</FuncFlag></xml>");
		return sb.toString();
	}

	//消息转发到客服
	 public String formatAnswerToCustomerService(String to, String from) {
		 StringBuffer sb = new StringBuffer();
		 Date date = new Date();
		 sb.append("<xml><ToUserName><![CDATA[");
		 sb.append(to);
		 sb.append("]]></ToUserName><FromUserName><![CDATA[");
		 sb.append(from);
		 sb.append("]]></FromUserName><CreateTime>");
		 sb.append(date.getTime());
		 sb.append("</CreateTime><MsgType><![CDATA[transfer_customer_service]]></MsgType></xml>");
		 return sb.toString();
	 }

	public String formatPiCtureXmlAnswer(String to, String from, Article article) {
		StringBuffer sb = new StringBuffer();
		Date date = new Date();
		sb.append("<xml><ToUserName><![CDATA[");
		sb.append(to);
		sb.append("]]></ToUserName><FromUserName><![CDATA[");
		sb.append(from);
		sb.append("]]></FromUserName><CreateTime>");
		sb.append(date.getTime());
		sb.append("</CreateTime><MsgType><![CDATA[news]]></MsgType><ArticleCount>1</ArticleCount><Articles><item><Title><![CDATA[");
		sb.append(article.getTitle());
		sb.append("]]></Title>");
		sb.append("<Description><![CDATA[");
		sb.append(article.getDescription());
		sb.append("]]></Description>");
		sb.append("<PicUrl><![CDATA[");
		sb.append(article.getPicUrl());
		sb.append("]]></PicUrl>");
		sb.append("<Url><![CDATA[");
		sb.append(article.getUrl());
		sb.append("]]></Url>");
		sb.append("</item></Articles></xml>");
		return sb.toString();
	}



}
