package com.bcxin.wechat.sys.web;

import com.bcxin.core.base.web.BaseController;
import com.bcxin.core.entity.SysRegion;
import com.bcxin.core.service.SysDictService;
import com.bcxin.core.service.SysRegionService;
import com.bcxin.enums.CompanyTypeEnum;
import com.bcxin.enums.DistributorLevelEnum;
import com.bcxin.wechat.bill.entity.BillOrderTotalView;
import com.bcxin.wechat.bill.service.WXBillService;
import com.bcxin.wechat.bill.service.WxBillNewService;
import com.bcxin.wechat.util.CTLUtil;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Map;

/**
 * 首页
 * Created by Apple on 2017/8/17.
 */
@Controller
@RequestMapping("${weChatPath}/primaryPage")
public class PrimaryPageController extends BaseController {

    private static Map<String,SysRegion> regions = Maps.newHashMap();

    @Autowired
    private WXBillService wxBillService;

    @Autowired
    SysDictService  sysDictService;

    @Autowired
    SysRegionService sysRegionService;

    @Autowired
    private WxBillNewService wxBillNewService;

    @RequestMapping("/list")
    public String list(@RequestParam Map<Object,Object> params , Model model){
        Map<Object,Object> map = (Map)getRequest().getSession().getAttribute("weixin_user");
        model.addAttribute("weixin_user",map);
        model.addAttribute("display","yes");
        model.addAttribute("displayShare","yes");
        if(map!=null){
            //资源方不显示下级管理
            if("4".equals(map.get("companyType"))){
                model.addAttribute("display","no");
            }
            //3级分销商不显示下级管理
            if("2".equals(map.get("companyType")) && "3".equals(map.get("distributionLevel"))){
                model.addAttribute("display","no");
            }
            if("1".equals(map.get("companyType"))){
                model.addAttribute("display","no");
                model.addAttribute("displayShare","no");
            }
        }

        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        model.addAttribute("total",wxBillService.cntCompany(p)) ;
        p.put("month","true");
        model.addAttribute("row",wxBillService.cntCompany(p)) ;
        model.addAttribute("p",params) ;
        return "wechat/primaryPage";
    }

    /**
     * [1.0.6] 版本新的首页界面
     * @param params
     * @param model
     * @return
     */
    @RequestMapping("/listNew")
    public String listNew(@RequestParam Map<Object,Object> params , Model model){
        Map<Object,Object> map = (Map)getRequest().getSession().getAttribute("weixin_user");
        model.addAttribute("weixin_user",map);
        model.addAttribute("display","yes");
        model.addAttribute("displayShare","yes");
        if(map!=null){
            //资源方不显示下级管理
            if("4".equals(map.get("companyType"))){
                model.addAttribute("display","no");
            }
            //3级分销商不显示下级管理
            if("2".equals(map.get("companyType")) && "3".equals(map.get("distributionLevel"))){
                model.addAttribute("display","no");
            }
            if("1".equals(map.get("companyType"))){
                model.addAttribute("display","no");
                model.addAttribute("displayShare","no");
            }
        }

        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        //订单统计
        BillOrderTotalView billOrderTotal=wxBillNewService.selectBillOrderTotal(p);
        model.addAttribute("billOrderTotal",billOrderTotal) ;
        Map monthMap=p;
        monthMap.put("currMonth","true");
        //本月订单统计
        BillOrderTotalView billOrderTotalMonth=wxBillNewService.selectBillOrderTotal(monthMap);
        model.addAttribute("billOrderTotalMonth",billOrderTotalMonth) ;
        model.addAttribute("p",params) ;

        String companyType=map.get("companyType").toString();
        if(CompanyTypeEnum.RESOUCER.getKey().equals(companyType)){
            return "wechat/primaryNewPage_L3";
        }else {
            String distributionLevel=map.get("distributionLevel").toString();
            if (DistributorLevelEnum.LEVEL_1.getKey().equals(distributionLevel)) {
                return "wechat/primaryNewPage";
            } else if (DistributorLevelEnum.LEVEL_2.getKey().equals(distributionLevel)) {
                return "wechat/primaryNewPage_L2";
            } else if (DistributorLevelEnum.LEVEL_3.getKey().equals(distributionLevel)) {
                return "wechat/primaryNewPage_L3";
            }
        }
        return "wechat/primaryNewPage";
    }


    @RequestMapping("/dict")
    public @ResponseBody Object dict(@RequestParam Map<Object,Object> params , Model model){
        return sysDictService.selectList(null);
    }
    @RequestMapping("/region")
    public @ResponseBody Object region(@RequestParam Map<Object,Object> params , Model model){
        if(regions.keySet().size()==0){ //缓存为空，就加入内容
            for(SysRegion sr : sysRegionService.selectList(null)){
                regions.put(String.valueOf(sr.getId()),sr); //map，key为region的id，value为对象
            }
        }
        return regions.get(String.valueOf(params.get("id")));
    }

    @RequestMapping("/query")
    public @ResponseBody Object query(@RequestParam Map<Object,Object> params , Model model){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        CTLUtil.out(wxBillService.weixinQueryBillList(p),getResponse());
        return null;
    }

    @RequestMapping("/detail")
    public @ResponseBody Object detail(@RequestParam Map<Object,Object> params , Model model){
        return null;
    }

}
