package com.bcxin.wechat.sys.service.impl;

import com.bcxin.core.base.service.impl.BaseServiceImpl;
import com.bcxin.core.entity.SysUser;
import com.bcxin.core.service.SysUserService;
import com.bcxin.core.service.SystemService;
import com.bcxin.core.util.SysLogUtils;
import com.bcxin.wechat.sys.dao.WeiXinUserDao;
import com.bcxin.wechat.sys.service.WeiXinUserService;
import com.bcxin.wechat.util.R;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 类名称：SysUserServiceImpl
 * 类描述：SysUser 表业务逻辑层接口实现类
 * 创建人：liujinju
 */
@Service
@Transactional
public class WeiXinUserServiceImpl extends BaseServiceImpl<WeiXinUserDao, SysUser> implements WeiXinUserService {

    @Autowired
    private SystemService systemService;

    @Autowired
    private SysUserService sysUserService;


    @Override
    public Map<Object,Object> getWeiXinUser(Map<Object, Object> p) {

        Map<Object,Object> map = dao.getWeiXinUser(p);
        return map;
    }

    @Override
    public R login(HttpServletRequest req, Map<Object, Object> p) {

        //根据用户名是否存在，账户不存在 还需要关联分销商
        //new EntityWrapper().addFilter("login_name={0}", p.get("login_name"))
        Map<Object,Object> map = this.getWeiXinUser(p);
//        if(StringUtils.isNotEmpty(String.valueOf(p.get("oppen_id")))){
//            map.put("oppenId",p.get("oppen_id"));
//        }
        if (map == null||map.get("loginName") == null) {
            return new R(false, "账号不存在");
        }

        //判断是否禁用，否则提示用户已经被禁用
        if ("0".equals(map.get("status"))){
            return new R(false, "账号被禁用");
        }

        //得到的结果判断密码是否匹配，密码不匹配
        if (!systemService.validatePassword(String.valueOf(p.get("login_password")), map.get("loginPassword").toString())){
            return new R(false, "密码错误");
        }


        //oppenID绑定用户名  更新用户
//        if (StringUtils.isNotEmpty(String.valueOf(p.get("oppen_id")))) {
//            //去除绑定oppenID用户
//            //查询 oppenId 用户
////            oppen_id
//            List<SysUser> list=  sysUserService.findListByOppenId(p.get("oppen_id").toString());
//            if(list!=null&&list.size()>0){
//                for(SysUser u:list){
//                    //去除 绑定用户
//                    u.setOppenId("");
//                    sysUserService.updateById(u);
//                }
//            }
//            //绑定用户
//            SysUser  user  =sysUserService.selectById(String.valueOf(map.get("id")));
//            user.setOppenId(String.valueOf(p.get("oppen_id")));
//            sysUserService.updateById(user);
//
//        }

        //session放入
        req.getSession().setAttribute("weixin_user", map);
        //记录登陆日志
        SysLogUtils.saveLog(req, "微信/手机登陆");
        return new R(true, "登陆成功");

    }

    @Override
    public Map<Object, Object> getMapByOppenId(String oppenId) {
        Map<Object,Object> p = new HashMap<>();
        p.put("oppen_id",oppenId);
        Map<Object,Object> map = dao.getWeiXinUser(p);
        return map;
    }


}