package com.bcxin.wechat.share.web;

import com.alibaba.fastjson.JSON;
import com.bcxin.common.constants.GlobalConfig;
import com.bcxin.common.dto.AjaxResult;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.core.entity.SysCompany;
import com.bcxin.models.platform.ConstantURL;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.bcxin.util.Encodes;
import com.bcxin.util.toolbox.StrUtil;
import com.bcxin.wechat.bill.service.WXBillService;
import com.bcxin.wechat.share.dao.WXShareMapper;
import com.bcxin.wechat.share.service.WXShareService;
import com.bcxin.wechat.util.CTLUtil;
import com.bcxin.wechat.util.PageResult;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * liyongqiang
 * 分享模块
 * 2017-8-18
 */
@Controller
@RequestMapping("${weChatPath}/share")
public class WXShareController extends BaseController {

    @Autowired
    WXShareService wxShareService;

    private static final String INDEX = getViewPath("wechat/share/share_product");
    private static final String SHARE_MANAGER = getViewPath("wechat/share/share_manager"); //产品管理页面

    /**
     * 产品分享的索引页
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/17 17:04
     */
    @RequestMapping("/shareIndex")
    public String productManager(Model model, HttpServletRequest request,@RequestParam Map params) {
        Map p = CTLUtil.init(request,params);
        //判断用户是否有展责险权限
        boolean  flag =wxShareService.isResponsibility(p.get("weixin_login_company_id")==null?"":p.get("weixin_login_company_id").toString());
        model.addAttribute("flag",flag);
        model.addAttribute("p",p);
        return SHARE_MANAGER;
    }

    @RequestMapping("index")
    public String index(Model model,@RequestParam Map<Object,Object> params) {
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        model.addAttribute("p",p);
        model.addAttribute("url",ConstantURL.getShareUrl());
        model.addAttribute("blbUrl", GlobalConfig.getConfig("BLB"));
        model.addAttribute("recommendCode", Encodes.encodeBase64(String.valueOf(p.get("weixin_login_company_id"))));
        //判断用户是否有展责险权限
        boolean  flag =wxShareService.isResponsibility(p.get("weixin_login_company_id")==null?"":p.get("weixin_login_company_id").toString());
        model.addAttribute("flag",flag);
        return INDEX;
    }

    /**
     * 资源方关联，分销商关联，
     */
    @RequestMapping("/query")
    public @ResponseBody Object query(@RequestParam Map<Object,Object> params , Model model){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        CTLUtil.out(wxShareService.query(p),getResponse());
        return null;
    }



    //选择产品页面
    @RequestMapping("/activityShareProduct")
    public String activityShareProduct(@RequestParam Map<Object,Object> params, Model model, HttpServletRequest req) {
        String  activityId=params.get("activityId").toString();
        //判断是否存在已经选中的产品id
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        if(p==null||p.get("weixin_login_company_id")==null){

        }else{
            String  productIds= wxShareService.getActivityProduct(activityId,p.get("weixin_login_company_id").toString());
            model.addAttribute("productIds",productIds);
            model.addAttribute("companyId",p.get("weixin_login_company_id"));
            req.getSession().setAttribute("activityId",activityId);
        }

        return "wechat/share/share_product_change";
    }

    //选择产品页面-填充数据
    @RequestMapping("/activityShareProductQuery")
    @ResponseBody
    public PageResult activityShareProductQuery(Model model, @RequestParam Map<Object,Object> params, HttpServletRequest req){
        Map p = CTLUtil.init(req,params);
        return wxShareService.getChangeProductListPage(p);

    }


    //保存选择产品页面
    @RequestMapping("/saveActivityShareProductChange")
    @ResponseBody
    public AjaxResult saveActivityShareProductChange(@RequestParam Map<Object,Object> params, Model model, HttpServletRequest req) {
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        String activityId=req.getSession().getAttribute("activityId").toString();
        String productId=params.get("productIds").toString();
        //判断选中的产品
        boolean  flag=false;
        if(StringUtils.isNotEmpty(productId)){
            //保存选择 产品-活动-关联账号
            flag=  wxShareService.saveShareProduct(activityId,productId,p.get("weixin_login_company_id").toString());

        }
        if(flag){
            success(true);
        }
        //跳到对应的活动详情
        return fail(true,"操作失败");

    }





}
