package com.bcxin.wechat.product.web;

import com.bcxin.common.dto.AjaxResult;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.core.entity.SysCompany;
import com.bcxin.core.service.SysCompanyService;
import com.bcxin.models.product.entity.ProductRelation;
import com.bcxin.models.product.service.ProductRelationService;
import com.bcxin.models.product.service.ProductService;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.util.toolbox.StrUtil;
import com.bcxin.wechat.partner.service.WeiXinPartnerService;
import com.bcxin.wechat.product.service.WeiXinProductRelationService;
import com.bcxin.wechat.product.service.WeiXinProductService;
import com.bcxin.wechat.util.CTLUtil;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.Map;

/**
 * liyongqiang
 * 分享模块
 * 2017-8-18
 */
@Controller
@RequestMapping("${weChatPath}/product")
public class WeCharProductController extends BaseController {

    private static final String PRODUCT_DISTRIBUTION = getViewPath("wechat/product/product_distribution"); //已分配 (第二页) 设置佣金

    private static final String PRODUCT_CHANGE = getViewPath("wechat/product/product_change");//可选择  (第一页)

    private static final String PRODUCT_DEL_CHANGE = getViewPath("wechat/product/product_del_change"); //可删除


    @Autowired
    private SysCompanyService sysCompanyService;

    @Autowired
    private ProductService productService;

    @Autowired
    private WeiXinProductService weiXinProductService;

    @Autowired
    private ProductRelationService productRelationService;

    @Autowired
    private WeiXinPartnerService weiXinPartnerService;

    @Autowired
    private   WeiXinProductRelationService   weiXinProductRelationService;


    @RequestMapping("/changeList/{oid}")
    public String changeList(Model model, HttpServletRequest request,@PathVariable Long oid) {
        //设置关联公司id
        model.addAttribute("companyId",oid);
        String  newType=request.getParameter("newType");
        model.addAttribute("newType",newType);
        return PRODUCT_CHANGE;
    }

    @RequestMapping(value = "/changeListQuery" , method = RequestMethod.POST)
    @ResponseBody
    public String changeListQuery(Model model,String companyId,HttpServletRequest req){


        Map<Object,Object> map1 = (Map<Object, Object>) req.getSession().getAttribute("weixin_user");
        SysCompany  company  =weiXinPartnerService.getCompanyByUserId(Long.parseLong(String.valueOf(map1.get("id"))));
        String likeValue = this.getParameter("likeValue");
        Map<Object,Object> map = (Map<Object, Object>) req.getSession().getAttribute("weixin_user");
        Map<String,Object> params = Maps.newHashMap();
        if(StrUtil.isNotBlank(companyId)) {
            if(StrUtil.split(companyId,",").length>0){
                if(map.get("cid").equals(StrUtil.toLong(StrUtil.split(companyId,",")[0]))){
                    return null;
                }
                SysCompany sysCompany = sysCompanyService.get(StrUtil.toLong(StrUtil.split(companyId,",")[0]));
                params.put("type",sysCompany.getDistributionLevel());
                model.addAttribute("type",sysCompany.getDistributionLevel());//设置分销商等级
                if (null != sysCompany && sysCompany.getCompanyType().equals(SysCompany.COMPANY_TYPE_DISTRIBUTOR)
                        && null != sysCompany.getDistributionLevel()&&sysCompany.getParent()!=null&&sysCompany.getParent().getId()!=null) {
                    params.put("relationId",sysCompany.getParent().getId());
                }
            }
        }
        params.put("companyId",companyId);
        params.put("likeValue",likeValue);
        params.put("status","1");
        Page<Map<String,Object>> page = this.getPage();
        weiXinProductService.getProductListPage(page,params,company.getDistributionLevel());
        return jsonPage(page);
    }

    @RequestMapping(value = "/saveProductRelation",method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult saveProductRelation(Model model, @RequestParam(required = true) String productIds,
                           @RequestParam(required = true)String companyId,
                           @RequestParam(required = true)Integer type){
        type=1;//1是分销商
        productRelationService.checkSave(productIds,companyId,type);
        return json(true,companyId);
    }





    @RequestMapping("distributionList/{oid}")
    public String distributionList(Model model, HttpServletRequest request,@PathVariable Long oid) {

        model.addAttribute("companyId",oid);
        String  newType=request.getParameter("newType");
        model.addAttribute("newType",newType);
        return PRODUCT_DISTRIBUTION;
    }




    @RequestMapping(value = "/distributionQuery" , method = RequestMethod.POST)
    @ResponseBody
    public String distributionQuery(Model model,String companyId,HttpServletRequest req){
        Map<Object,Object> map1 = (Map<Object, Object>) req.getSession().getAttribute("weixin_user");
        SysCompany  company  =weiXinPartnerService.getCompanyByUserId(Long.parseLong(String.valueOf(map1.get("id"))));
        String likeValue = this.getParameter("likeValue");
        Map<String,Object> params = Maps.newHashMap();
        params.put("likeValue",likeValue);//模糊查询
        params.put("relationId",companyId);//关联ID
        params.put("type",1); //关联类型*/
        Page<Map<String,Object>> page = this.getPage();
        weiXinProductService.getProductAssignedList(page,params,company.getDistributionLevel());
        return jsonPage(page);
    }



    @RequestMapping("delChangeList/{oid}")
    public String delChangeList(Model model, HttpServletRequest request,@PathVariable Long oid) {
        model.addAttribute("companyId",oid);
        String  newType=request.getParameter("newType");
        model.addAttribute("newType",newType);
        return PRODUCT_DEL_CHANGE;
    }

    @RequestMapping(value = "/delChageListQuery" , method = RequestMethod.POST)
    @ResponseBody
    public String delChageListQuery(Model model,String companyId,HttpServletRequest req){
        Map<Object,Object> map1 = (Map<Object, Object>) req.getSession().getAttribute("weixin_user");
        SysCompany  company  =weiXinPartnerService.getCompanyByUserId(Long.parseLong(String.valueOf(map1.get("id"))));
        String likeValue = this.getParameter("likeValue");
        Map<String,Object> params = Maps.newHashMap();
        params.put("likeValue",likeValue);//模糊查询
        params.put("relationId",companyId);//关联ID
        params.put("type",1); //关联类型*/
        Page<Map<String,Object>> page = this.getPage();
        weiXinProductService.getProductAssignedList(page,params,company.getDistributionLevel());
        return jsonPage(page);
    }



    @RequestMapping(value = "/saveProductDelRelation",method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult saveProductDelRelation(Model model, @RequestParam(required = true) String productIds,
                           @RequestParam(required = true)String companyId,
                           @RequestParam(required = true)Integer type){
        type=1;//1是分销商
        boolean flag= weiXinProductRelationService.saveProductRelation(productIds,companyId,type);
        if(flag){
            success(true);
        }
        return fail(true,"操作失败");


    }


    @RequestMapping(value = "/setBrokerage" , method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult setBrokerage(Model model, BigDecimal brokerage, String oid){
        //查询关联对象
        System.out.printf("设置佣金");
        //设置佣金
        ProductRelation  pr= productRelationService.selectById(oid);
        pr.setFee(brokerage);
        productRelationService.save(pr);
        return new AjaxResult(true);
    }


    @RequestMapping(value = "/getBrokerage" , method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult setBrokerage(Model model,  String productId,HttpServletRequest req){

        Map<Object,Object> map1 = (Map<Object, Object>) req.getSession().getAttribute("weixin_user");
        SysCompany  company  =weiXinPartnerService.selectById(Long.parseLong(String.valueOf(map1.get("cid"))));

        //获取一级费率佣金
        ProductRelation  pr= productRelationService.selectOne(new EntityWrapper().addFilter("relation_id={0} and product_id={1}",company.getId(),productId));
        return new AjaxResult(true,pr.getFee());
    }




}
