package com.bcxin.wechat.partner.web;

import com.bcxin.common.dto.AjaxResult;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.core.entity.*;
import com.bcxin.core.service.*;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.util.toolbox.StrUtil;
import com.bcxin.wechat.partner.service.WeiXinPartnerService;
import com.bcxin.wechat.util.CTLUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * liyongqiang
 * 合作机构
 * 2017-8-18
 */
@Controller
@RequestMapping("${weChatPath}/partner")
public class WeCharPartnerController extends BaseController {


    @Autowired
    private WeiXinPartnerService weiXinPartnerService;

    @Autowired
    private SysCompanyService sysCompanyService;//机构服务

    @Autowired
    private SysUserService sysUserService;

    @Autowired
    private SysRoleService sysRoleService;


    @Autowired
    private SysAreaRelationService sysAreaRelationService;

    @Autowired
    private SysCompanyContactsService sysCompanyContactsService;//联系人服务

    private static final String INDEX = getViewPath("wechat/partner/partner_sub_list");

    private static final String DETATIL = getViewPath("wechat/partner/partner_sub_detail");

    private static final String ADD_PARTNER = getViewPath("wechat/partner/partner_sub_add");

    private static final String UPD_PARTNER = getViewPath("wechat/partner/partner_sub_upd");

    private static final String ACCCOUNT_PARTNER = getViewPath("wechat/partner/partner_account_info");

    private static final String AREA = getViewPath("wechat/partner/area");


    /**
     * 分销商列表
     * @param model
     * @param request
     * @return
     */
    @RequestMapping("list")
    public String list(Model model, HttpServletRequest request) {
        return INDEX;
    }


    /**
     * 分销商查询
     * @param params
     * @param req
     * @param resp
     * @return
     */
    @RequestMapping(value = "/query" , method = RequestMethod.POST)
    public @ResponseBody
    Object query(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
        Map<Object,Object> p = CTLUtil.init(req,params);
        Map<Object,Object> map = (Map<Object, Object>) req.getSession().getAttribute("weixin_user");
        SysCompany  company  =weiXinPartnerService.getCompanyByUserId(Long.parseLong(String.valueOf(map.get("id"))));
        p= weiXinPartnerService.setCompanyData(company,p);
        CTLUtil.out(weiXinPartnerService.query(p),resp);

        return null;
    }


    /**
     * 分销商详情
     * @param model
     * @param request
     * @param oid
     * @return
     */
    @RequestMapping("/detatil/{oid}")
    public String detatil(Model model, HttpServletRequest request,  @PathVariable Long oid) {
        SysCompany  sysCompany = sysCompanyService.getSysCompany(new SysCompany(oid));
        model.addAttribute("company", sysCompany);
        Map<String,Object> map = Maps.newHashMap();
        //查询关联产品
        List<Map<String,Object>> insProlist = sysCompanyService.getInsProductMap(map);
        model.addAttribute("insProlist",insProlist);
        //查询关联联系人
        List<SysCompanyContacts> contactsList = sysCompanyContactsService.selectList(new EntityWrapper().addFilter("company_id={0}",sysCompany.getId()));
        model.addAttribute("contactsList",contactsList);
        return DETATIL;
    }


    /**
     * 初始化添加分销商
     * @param model
     * @param request
     * @return
     */
    @RequestMapping("/addPartner")
    public String addPartner(Model model, HttpServletRequest request) {
        //添加下级分销商
        return ADD_PARTNER;
    }


    /**
     * 修改分销商
     * @param model
     * @param request
     * @param oid
     * @return
     */
    @RequestMapping("/updPartner/{oid}")
    public String updPartner(Model model, HttpServletRequest request,@PathVariable Long oid) {
        //修改下级分销商
        SysCompany  sysCompany = sysCompanyService.getSysCompany(new SysCompany(oid));
        model.addAttribute("company", sysCompany);
        String newType = request.getParameter("newType");//新流程标识
        model.addAttribute("newType", newType);//新流程
        //查询关联联系人
        List<SysCompanyContacts> contactsList = sysCompanyContactsService.selectList(new EntityWrapper().addFilter("company_id={0}",sysCompany.getId()));
        model.addAttribute("contactsList",contactsList);
        return UPD_PARTNER;
    }


    /**
     * 保存分销商
     * @param sysCompany
     * @param req
     * @return
     */
    @RequestMapping("/savePartner")
    @ResponseBody
    public AjaxResult savePartner(@ModelAttribute("syscompany") SysCompany sysCompany,HttpServletRequest req){
        sysCompany.setSign("0");
        sysCompany.setCompanyType(2);//默认是分销商类型
        String msg = beanValidator(sysCompany);
        if(StrUtil.isNotBlank(msg)){
            return fail(false,msg);
        }
        List<SysCompanyContacts> list = Lists.newArrayList();
        Map<Object,Object> map = (Map<Object, Object>) req.getSession().getAttribute("weixin_user");
        SysCompany  company  =weiXinPartnerService.getCompanyByUserId(Long.parseLong(String.valueOf(map.get("id"))));
        String  level=map.get("distributionLevel").toString();
        sysCompany.setDistributionLevel((Integer.parseInt(level)+1)+"");
        sysCompany.setParent(company);
        //验证数据
        msg = sysCompanyService.checkData(sysCompany);
        if(StrUtil.isNotBlank(msg)){
            return fail(false, msg);
        }
        sysCompanyService.save(sysCompany);
        if(null!=sysCompany.getContactsList()&&sysCompany.getContactsList().size()>0){
            List<String> phoneList = Lists.newArrayList();
            for(SysCompanyContacts s:sysCompany.getContactsList()){
                s.setSysCompany(sysCompany);
                phoneList.add(s.getContactsWay());
                list.add(s);
            }
            sysCompanyContactsService.insertOrUpdateBatch(list);
        }
        return json(true,sysCompany.getId().toString());
    }


    /**
     * 保存公司
     * @param req
     * @param companyId
     * @param status
     * @return
     */
    @RequestMapping("/savePartnerStatus")
    @ResponseBody
    public AjaxResult savePartnerStatus(HttpServletRequest req,Long companyId,Integer status){
        SysCompany  sysCompany = sysCompanyService.getSysCompany(new SysCompany(companyId));
        sysCompany.setStatus(status);
        sysCompanyService.save(sysCompany);
        return new AjaxResult(true);
    }


    @RequestMapping("/account/{oid}")
    public String account(Model model, HttpServletRequest req,@PathVariable Long oid) {
        String newType = req.getParameter("newType");//新流程标识
        model.addAttribute("newType", newType);//新流程
        //查询登陆用户的机构
        Map<Object,Object> map = (Map<Object, Object>) req.getSession().getAttribute("weixin_user");
        SysCompany  company  =weiXinPartnerService.getCompanyByUserId(Long.parseLong(String.valueOf(map.get("id"))));
        //查询添加账号的机构
        SysCompany  sysCompany = sysCompanyService.getSysCompany(new SysCompany(oid));
        //根据机构查询对应的账号列表
        //如果存在取第一个
        List<SysUser> list= sysUserService.selectList(new EntityWrapper().addFilter("company_id={0}",sysCompany.getId()));
        if(list!=null&&list.size()>0){
            model.addAttribute("sysUser",list.get(0));
            model.addAttribute("companyType",sysCompany.getCompanyType());
        }
        model.addAttribute("companyId", oid);
        //查询添加账号机构的角色
        List<SysRole> sysRoles = weiXinPartnerService.getSysRoleList(company);
        model.addAttribute("sysRoles", sysRoles);
        return ACCCOUNT_PARTNER;
    }

    /**
     * 保存账号
     * @param sysUser
     * @return
     */
    @RequestMapping(value = "/account/save", method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult saveAccount(@ModelAttribute("sysUser") SysUser sysUser){
        String[] roleIds = getParameterValues("roleId");
        sysUser.setWebType("0");  //后台用户标识
        sysUser.setWebUserId("0"); //后台用户标识
        if(sysUser.getId() == null){
            if(sysUserService.checkLoginName(sysUser.getLoginName())){
                return fail(false, "该登录用户名已被使用");
            }
            sysUserService.insertSysUser(sysUser, roleIds);//创建用户及插入角色记录
            return success(true, "用户创建成功!");
        }else{
            sysUserService.updateUserInfoBySystem(sysUser, roleIds);//更新用户及角色记录
            return success(true, "用户信息修改成功!");
        }
    }


    /**
     * 获取某个区域
     * @param model
     * @param request
     * @param oid
     * @return
     */
    @RequestMapping("/area/{oid}")
    public String area(Model model, HttpServletRequest request,@PathVariable Long oid) {
        //查询区域
        SysCompany  sysCompany = sysCompanyService.getSysCompany(new SysCompany(oid));
        //查询已经设置好的区域
        model.addAttribute("sysCompany", sysCompany);
        Map<Object,Object> map = (Map<Object, Object>) request.getSession().getAttribute("weixin_user");
        model.addAttribute("cid", map.get("cid"));
        String newType = request.getParameter("newType");//新流程标识
        model.addAttribute("newType", newType);//新流程
        return AREA;
    }


    /**
     * 获取上级分销商的区域
     * @param model
     * @param companyId
     * @return
     */
    @RequestMapping(value = "/getParentArea")
    @ResponseBody
    public String getParentArea(Model model, Long companyId){
        Page<SysAreaRelation> page = getPage();
        if(null!=companyId){
            SysAreaRelation areaRelation = new SysAreaRelation();
            areaRelation.setType(2);//设置分销商
            areaRelation.setSysCompany(new SysCompany(companyId));
            areaRelation.setDelFlag("0");
            sysAreaRelationService.findListPage(page,areaRelation);
        }
        return jsonPage(page);
    }



    /**
     * 获取机构限制销售区域
     * @return
     */
    @RequestMapping(value = "/getAreaList")
    @ResponseBody
    public String getAreaList(Model model, Long companyId){
        Page<SysAreaRelation> page = getPage();
        if(null!=companyId){
            SysAreaRelation areaRelation = new SysAreaRelation();
            areaRelation.setType(2);//设置分销商
            areaRelation.setSysCompany(new SysCompany(companyId));
            areaRelation.setDelFlag("0");
            sysAreaRelationService.findListPage(page,areaRelation);
        }
        return jsonPage(page);
    }


    /**
     * 批量保存销售区域
     * @param model
     * @param companyId
     * @return
     */
    @RequestMapping(value = "/saveAreaList")
    @ResponseBody
    public AjaxResult saveAreaList(Model model, Long companyId){
        String [] provinces=getRequest().getParameterValues("province");
        String  []citys=getRequest().getParameterValues("city");
        String  []districts=getRequest().getParameterValues("district");
        //干掉以前关于这个分销商的设置关系
        //重新设置关系

        return weiXinPartnerService.saveArea(companyId,provinces,citys,districts);
    }

}
