package com.bcxin.wechat.partner.service.impl;

import com.bcxin.common.dto.AjaxResult;
import com.bcxin.core.base.service.impl.BaseServiceImpl;
import com.bcxin.core.dao.SysRoleDao;
import com.bcxin.core.entity.SysAreaRelation;
import com.bcxin.core.entity.SysCompany;
import com.bcxin.core.entity.SysRegion;
import com.bcxin.core.entity.SysRole;
import com.bcxin.core.service.SysAreaRelationService;
import com.bcxin.core.service.SysUserService;
import com.bcxin.core.service.SystemService;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.bcxin.util.toolbox.Str2Utils;
import com.bcxin.wechat.partner.dao.WeiXinPartnerDao;
import com.bcxin.wechat.partner.service.WeiXinPartnerService;
import com.bcxin.wechat.util.PageResult;
import com.bcxin.wechat.util.R;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;


@Service
@Transactional
public class WeiXinPartnerServiceImpl extends BaseServiceImpl<WeiXinPartnerDao, SysCompany> implements WeiXinPartnerService {

    @Autowired
    private SystemService systemService;

    @Autowired
    private SysUserService sysUserService;


    @Autowired
    private SysRoleDao sysRoleDao;

    @Autowired
    private SysAreaRelationService sysAreaRelationService;

    @Override
    public PageResult query(Map<Object, Object> p) {
        return new PageResult(dao.queryCnt(p), dao.query(p));
    }

    @Override
    public Map<Object, Object> setCompanyData(SysCompany company, Map<Object, Object> p) {
        p.put("companyId", company.getId());
        if (StringUtils.isNotEmpty(company.getDistributionLevel())) {
            if ("3".equals(company.getDistributionLevel())) {
                p.put("distributionLevel", 3);
            } else {
                p.put("distributionLevel", Integer.parseInt(company.getDistributionLevel()) + 1);
            }
        }

        return p;
    }

    @Override
    public SysCompany getCompanyByUserId(Long uid) {
        return dao.getCompanyByUserId(uid);
    }

    @Override
    public R add(Map<Object, Object> p) {
        return null;
    }

    @Override
    public R upd(Map<Object, Object> p) {
        return null;
    }

    @Override
    public List<SysRole> getSysRoleList(SysCompany sysCompany) {
        List<String> list = Lists.newArrayList();
        if (sysCompany.getDistributionLevel().equals(SysCompany.DISTRIBUTIONLEVEL_ONE)) {
            list.add("二级分销商角色");
        } else if (sysCompany.getDistributionLevel().equals(SysCompany.DISTRIBUTIONLEVEL_TWO)) {
            list.add("三级分销商角色");
        }
        EntityWrapper entityWrapper = new EntityWrapper();
        if (list.size() > 0) {
            entityWrapper.addFilter(Str2Utils.arrayToDBSqlStr(Str2Utils.toStringArray(list), "role_name"));
        }
        return sysRoleDao.selectList(entityWrapper);
    }

    @Override
    public AjaxResult saveArea(Long companyId, String[] provinces, String[] citys, String[] districts) {

        // TODO: 2017/08/24 需要做事物。先移除掉这个分销商的所有区域设置。然后再保存所有区域
        sysAreaRelationService.delete(new EntityWrapper<SysAreaRelation>().addFilter("company_id={0} and type=2",companyId));
        for(int i=0;i<provinces.length;i++){
            SysAreaRelation sysAreaRelation = new SysAreaRelation();
            sysAreaRelation.setType(2);//设置分销商
            sysAreaRelation.setSysCompany(new SysCompany(companyId));
            sysAreaRelation.setDelFlag("0");
            sysAreaRelation.setCreateDate(new Date());
            sysAreaRelation.setProvince(new SysRegion(Long.parseLong(provinces[i])));
            sysAreaRelation.setCitytype(new SysRegion(Long.parseLong(citys[i])));
            sysAreaRelation.setCity(new SysRegion(Long.parseLong(districts[i])));
            sysAreaRelationService.save(sysAreaRelation);
        }
        return new AjaxResult(true,companyId.toString());
    }
}