package com.bcxin.wechat.bill.web;

import com.bcxin.core.base.web.BaseController;
import com.bcxin.enums.CompanyTypeEnum;
import com.bcxin.enums.DistributorLevelEnum;
import com.bcxin.wechat.bill.entity.BillOrderView;
import com.bcxin.wechat.bill.service.WxBillCommonService;
import com.bcxin.wechat.bill.service.WxBillNewService;
import com.bcxin.wechat.util.CTLUtil;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
import java.util.Map;

/**
 * 微信端-收入管理 界面跳转入扣
 * @author hzp
 * @date 2018/05/16
 */
@Controller
@RequestMapping("${weChatPath}/billNewPage")
public class WxBillNewPageController extends BaseController {

    @Autowired
    private WxBillNewService wxBillNewService;
    @Autowired
    private WxBillCommonService wxBillCommonService;

    /**
     * 收入管理-产品汇总
     * @param params
     * @param model
     * @return
     */
    @RequestMapping("/index")
    public String index(@RequestParam Map<Object,Object> params , Model model){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        model.addAttribute("billOrderTotal",wxBillNewService.selectBillOrderTotal(params)) ;
        model.addAttribute("p",params) ;

        String companyType=p.get("weixin_login_company_type").toString();
        if(CompanyTypeEnum.RESOUCER.getKey().equals(companyType)){
            return "wechat/billNew/bill_new_manager_L3";
        }else {
            String distributionLevel=p.get("weixin_login_distribution_level").toString();
            if (DistributorLevelEnum.LEVEL_1.getKey().equals(distributionLevel)) {
                return "wechat/billNew/bill_new_manager";
            } else if (DistributorLevelEnum.LEVEL_2.getKey().equals(distributionLevel)) {
                return "wechat/billNew/bill_new_manager_L2";
            } else if (DistributorLevelEnum.LEVEL_3.getKey().equals(distributionLevel)) {
                return "wechat/billNew/bill_new_manager_L3";
            }
        }
        return "wechat/billNew/bill_new_manager";
    }

    /**
     * 跳转到账单列表页面
     * @param params
     * @param model
     * @return
     */
    @RequestMapping("/gotoBillPage")
    public String gotoBillPage(@RequestParam Map<Object,Object> params , Model model){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        params.put("filterProductType",params.get("product_type"));
        model.addAttribute("billOrderTotal",wxBillNewService.selectBillOrderTotal(params)) ;
        model.addAttribute("p",params) ;

        String companyType=p.get("weixin_login_company_type").toString();
        if(CompanyTypeEnum.RESOUCER.getKey().equals(companyType)){
            return "wechat/billNew/bill_new_list_L3";
        }else {
            String distributionLevel=p.get("weixin_login_distribution_level").toString();
            if (DistributorLevelEnum.LEVEL_1.getKey().equals(distributionLevel)) {
                return "wechat/billNew/bill_new_list";
            } else if (DistributorLevelEnum.LEVEL_2.getKey().equals(distributionLevel)) {
                return "wechat/billNew/bill_new_list_L2";
            } else if (DistributorLevelEnum.LEVEL_3.getKey().equals(distributionLevel)) {
                return "wechat/billNew/bill_new_list_L3";
            }
        }

        return "wechat/billNew/bill_new_list";
    }

    /**
     * 查询订单详情
     * @param params
     * @param orderId 订单id
     * @param model
     * @return
     */
    @RequestMapping("/detail/{orderId}")
    public String detail(@RequestParam Map<Object,Object> params, @PathVariable String orderId, Model model){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        model.addAttribute("p",params) ;
        p.put("orderId",orderId);
        BillOrderView billOrderView=wxBillNewService.selectOrderDetail(params);
        model.addAttribute("orderDetail", billOrderView);
        if(billOrderView!=null){
            String orderNo=billOrderView.getOrderNo();
            model.addAttribute("orderDetailPay", wxBillNewService.selectOrderPayStatus(orderNo));
        }
        return "wechat/billNew/bill_new_detail";
    }

    /**
     * 筛选界面
     * @param params
     * @param model
     * @return
     */
    @RequestMapping("/billCondition")
    public String billCondition(@RequestParam Map<Object,Object> params , Model model){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        model.addAttribute("p",params) ;
        return "wechat/billNew/bill_new_condition";
    }

    /**
     * 区域筛选界面
     * @param params
     * @param model
     * @return
     */
    @RequestMapping("/billConditionCity")
    public String billConditionCity(@RequestParam Map<Object,Object> params , Model model){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        model.addAttribute("p",params) ;
        return "wechat/billNew/bill_new_condition_city";
    }

    /**
     * 分销商筛选界面
     * @param params
     * @param model
     * @return
     */
    @RequestMapping("/billConditionCompany")
    public String billConditionCompany(@RequestParam Map<Object,Object> params , Model model){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        model.addAttribute("p",params) ;
        return "wechat/billNew/bill_new_condition_company";
    }

    /**
     * 项目筛选界面
     * @param params
     * @param model
     * @return
     */
    @RequestMapping("/billConditionProject")
    public String billConditionProject(@RequestParam Map<Object,Object> params , Model model){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        model.addAttribute("p",params) ;
        return "wechat/billNew/bill_new_condition_project";
    }

    /**
     * 获取项目列表
     * @param params
     * @return
     */
    @RequestMapping("/getProjectList")
    @ResponseBody
    public Object getProjectList(@RequestParam Map<Object,Object> params){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        params.put("filterProductType",params.get("product_type"));
        return wxBillCommonService.selectProjectNameByOrderList(p);
    }

    /**微信登录机构类型*/
    private String wxCompanyTypeKey="weixin_login_company_type";
    private String wxCompanyIdKey="weixin_login_company_id";
    /**
     * 获取分销商
     * @param params
     * @return
     */
    @RequestMapping("/getDistributionList")
    @ResponseBody
    public Object getDistributionList(@RequestParam Map<Object,Object> params){
        Map<Object,Object> map = CTLUtil.init(getRequest(),params);
        if(map.containsKey(wxCompanyTypeKey) && map.containsKey(wxCompanyIdKey)){
            if(CompanyTypeEnum.DISTRIBUTOR.getKey().equals(map.get(wxCompanyTypeKey))) {
                return wxBillCommonService.selectDistributionWithLower(map);
            }else if(CompanyTypeEnum.RESOUCER.getKey().equals(map.get(wxCompanyTypeKey))){
                return wxBillCommonService.selectDistributionByResource(map);
            }
        }
        return null;
    }

    /**
     * 获取销售区域
     * @param params
     * @return
     */
    @RequestMapping("/getAreaInfo")
    @ResponseBody
    public Object getAreaInfo(@RequestParam Map<Object,Object> params){
        Map<Object,Object> map = CTLUtil.init(getRequest(),params);
        Map<String,Object> resultMap=Maps.newHashMap();
        //省
        resultMap.put("province",wxBillCommonService.selectSellAreaProvinceById(map));
        //市
        resultMap.put("city",wxBillCommonService.selectSellAreaCityById(map));
        //区
        resultMap.put("district",wxBillCommonService.selectSellAreaDistrictById(map));
        CTLUtil.out(resultMap,getResponse());
        return null;
    }

    /**
     * 获取销售区域-省份
     * @param params
     * @return
     */
    @RequestMapping("/getAreaInfoWithProvince")
    @ResponseBody
    public Object getAreaInfoWithProvince(@RequestParam Map<Object,Object> params){
        Map<Object,Object> map = CTLUtil.init(getRequest(),params);
        Map<String,Object> resultMap=Maps.newHashMap();
        resultMap.put("province",wxBillCommonService.selectSellAreaProvinceById(map));
        CTLUtil.out(resultMap,getResponse());
        return null;
    }

    /**
     * 获取销售区域-城市
     * @param params
     * @return
     */
    @RequestMapping("/getAreaInfoWithCity")
    @ResponseBody
    public Object getAreaInfoWithCity(@RequestParam Map<Object,Object> params){
        Map<Object,Object> map = CTLUtil.init(getRequest(),params);
        Map<String,Object> resultMap=Maps.newHashMap();
        resultMap.put("city",wxBillCommonService.selectSellAreaCityById(map));
        CTLUtil.out(resultMap,getResponse());
        return null;
    }

    /**
     * 获取销售区域-区域
     * @param params
     * @return
     */
    @RequestMapping("/getAreaInfoWithDistrict")
    @ResponseBody
    public Object getAreaInfoWithDistrict(@RequestParam Map<Object,Object> params){
        Map<Object,Object> map = CTLUtil.init(getRequest(),params);
        Map<String,Object> resultMap=Maps.newHashMap();
        resultMap.put("district",wxBillCommonService.selectSellAreaDistrictById(map));
        CTLUtil.out(resultMap,getResponse());
        return null;
    }
}
