package com.bcxin.wechat.bill.web;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.bcxin.common.constants.GlobalConfig;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.util.DownUtils;
import com.bcxin.util.ExcelUtil;
import com.bcxin.util.FileUtils;
import com.bcxin.util.TransferUtil;
import com.bcxin.util.pdf.PdfHelper;
import com.bcxin.util.qrcode.QrcodeHelp;
import com.bcxin.wechat.activity.entity.WeCharActivity;
import com.bcxin.wechat.activity.service.WeCharActivityService;
import com.bcxin.wechat.bill.entity.BillOrderTotalView;
import com.bcxin.wechat.bill.entity.BillOrderView;
import com.bcxin.wechat.bill.service.WxBillNewService;
import com.bcxin.wechat.util.CTLUtil;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import sun.misc.BASE64Decoder;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;

/**
 * 微信端-收入管理 调用入口
 * @author hzp
 * @date 2018/05/16
 */
@Controller
@RequestMapping("${weChatPath}/billNew")
public class WxBillNewController extends BaseController {

    /**展会活动宣传页模板路径*/
    private String templateFilePath="/template/act/templateAct.html";
    /**生成展会活动宣传二维码Logo路径*/
    private String qrCodeLogoPath="/template/act/blb_logo.png";
    /**二维码生成保存路径*/
    private String qrCodeSavePath="/templateAct/qrcode/";
    /**生成PDF模板字体*/
    private String templateFont;
    /**生成PDF的保存路径*/
    private String pdfSavePath="/templateAct/pdf";
    /**生成HTML保存路径*/
    private String htmlSavePath="/templateAct/html";
    /**生成excel保存路径*/
    private String excelSavePath="/temp/xls";

    @Autowired
    private WxBillNewService wxBillNewService;
    @Autowired
    private WeCharActivityService weCharActivityService;

    public WxBillNewController(){
        this.templateFilePath=this.getClass().getResource("/").getPath() + templateFilePath;
        this.qrCodeLogoPath=this.getClass().getResource("/").getPath() + qrCodeLogoPath;
    }

    /**
     * 根据产品类型-汇总订单
     * @param params
     * @return
     */
    @RequestMapping("/getBillTotalByProduct")
    @ResponseBody
    public List<BillOrderTotalView> selectBillProductTotal(@RequestParam Map<Object,Object> params){
        Map map = CTLUtil.init(getRequest(),params);
        return wxBillNewService.selectBillOrderTotalByProduct(map);
    }

    /**
     * 订单汇总
     * @param params
     * @return
     */
    @RequestMapping("/getBillOrderTotal")
    @ResponseBody
    public BillOrderTotalView selectBillOrderTotal(@RequestParam Map<Object,Object> params){
        Map map = CTLUtil.init(getRequest(),params);
        return wxBillNewService.selectBillOrderTotal(map);
    }

    /**
     * 查询日结订单明细列表
     * @param params
     * @return
     */
    @RequestMapping("/getBillOrderList")
    @ResponseBody
    public Object selectBillFeeOrderList(@RequestParam Map<Object,Object> params){
        Map map = CTLUtil.init(getRequest(),params);
        CTLUtil.out(wxBillNewService.selectBillOrderPage(map),getResponse());
        return null;
    }

    /**
     * 获取订单详情
     * @param orderId
     * @return
     */
    @RequestMapping("/orderDetail/{companyId}/{orderId}")
    @ResponseBody
    public Object getOrderDetail(@PathVariable String companyId,@PathVariable String orderId){
        Map<Object,Object> map=Maps.newHashMap();
        map.put("weixin_login_company_id",companyId);
        map.put("orderId",orderId);
        return wxBillNewService.selectOrderDetail(map);
    }

    /**
     * 获取订单的支付状态
     * @param orderNo
     * @return
     */
    @RequestMapping("/orderPayStatus/{orderNo}")
    @ResponseBody
    public Object payStatus(@PathVariable String orderNo){
        return wxBillNewService.selectOrderPayStatus(orderNo);
    }

    /**
     * 导出excel-订单信息
     * @param request
     * @param response
     */
    @RequestMapping("exportOrderExcel")
    public void exportOrderExcel(HttpServletRequest request,HttpServletResponse response){
        try {
            byte[] bt = (new BASE64Decoder()).decodeBuffer(request.getParameter("params"));
            //解密后的字符串：
            String paramsJson=new String(bt,"utf-8");
            String reqParams= URLDecoder.decode(paramsJson);

            Map<Object, Object> params = JSONObject.parseObject(reqParams, new TypeReference<Map<Object, Object>>(){});
            Map map = CTLUtil.init(getRequest(),params);
            String downFileName=map.get("excelName").toString();
            String sheetName=map.get("sheetName").toString();
            map.remove("limit");
            map.remove("offset");
            String baseExcelPath=getProjectPath(request)+"/"+excelSavePath;
            FileUtils.checkDirExists(baseExcelPath);
            String fileName=System.currentTimeMillis()+".xls";
            String excelFullPath=baseExcelPath+"/"+fileName;

            String[] headers = {"订单号", "产品名称", "产品分类", "项目活动", "有效日期", "是否分期", "支付状态", "来源", "支付时间", "订单总额", "佣金收入", "下级收入", "净收入" };
            String [] keys= {"orderNo","productName","productTypeName","projectName","endDate","stagesName","payStatusName","sourceCompanyName","payDate","orderAmount","currOrderAmount","lowerOrderAmount","currAmount" };
            List rowList=wxBillNewService.selectBillOrder(map);
            List<Map<String, Object>> listMap=TransferUtil.convertListToMap(rowList,BillOrderView.class);
            //生成excel
            ExcelUtil.createExcel(excelFullPath,sheetName,headers,keys,listMap);
            //下载文件
            DownUtils.downFile(excelFullPath,downFileName,true,response);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    /**
     * 下载宣传页
     * @param
     */
    @RequestMapping("/downSharePage/{activityId}")
    public void downSharePage(@PathVariable String activityId, HttpServletRequest request,HttpServletResponse response){
        try {
            String uuid=System.currentTimeMillis()+"";
            WeCharActivity weCharActivity=weCharActivityService.selectById(activityId);
            /**活动名称*/
            String activityName=weCharActivity.getActivityName();
            String pdfFileName=createActivityPdf(uuid,activityId,activityName,request);
            if(pdfFileName!=null){
                /**下载文件*/
                DownUtils.downFile(pdfFileName, "《"+activityName+"展会投保须知》.pdf", Boolean.TRUE, response);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    /**
     * 生成展会活动宣传页pdf
     * @param uuid
     * @param activityId
     */
    public String createActivityPdf(String uuid,String activityId,String activityName,HttpServletRequest request){
        try {
            //生成pdf存放目录
            String basePdfPath=this.getProjectPath(request)+"/"+this.pdfSavePath;
            //生成二维码存放目录
            String baseQrCodePath=getProjectPath(request)+"/"+qrCodeSavePath;
            //生成HTML存放目录
            String baseHtmlPath=getProjectPath(request)+"/"+htmlSavePath;
            FileUtils.checkDirExists(basePdfPath);
            FileUtils.checkDirExists(baseQrCodePath);
            FileUtils.checkDirExists(baseHtmlPath);
            //pdf文件名
            String pdfTempFileName = basePdfPath+"/"+uuid + "_" + activityId + "_tmp.pdf";
            String pdfFileName = basePdfPath+"/"+uuid + "_" + activityId + ".pdf";
            //二维码文件名
            String qrCodeFileName=baseQrCodePath+"/"+uuid + "_" + activityId + ".jpg";
            //新的HTML文件名
            String htmlFileName=baseHtmlPath+"/"+uuid + "_" + activityId + ".html";

            /**生成二维码图片*/
            StringBuffer url = new StringBuffer(GlobalConfig.getConfig("BLB")+"weixin/product/win/prolist/"+activityId);
            String parseText="（扫码投保，展会无忧）";
            QrcodeHelp.createQrcodeWithText(url.toString(), qrCodeFileName, this.qrCodeLogoPath, parseText);

            //转换成pdf
            String content = org.apache.commons.io.FileUtils.readFileToString(new File(this.templateFilePath));
            content = content.replace("{{activityName}}",activityName);
            org.apache.commons.io.FileUtils.write(new File(htmlFileName),content);
            PdfHelper.htmlToPdf(htmlFileName,pdfTempFileName,getFontPath(),baseQrCodePath);

            /**往pdf写入二维码图片*/
            String pdfPathNew="";
            PdfHelper.addPictureToPdf(pdfTempFileName,pdfFileName,qrCodeFileName);

            //删除文件
            FileUtils.deleteFile(pdfTempFileName);
            FileUtils.deleteFile(qrCodeFileName);
            FileUtils.deleteFile(htmlFileName);
            return pdfFileName;
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 获取当前工程路径
     * @param request
     * @return
     */
    public String getProjectPath(HttpServletRequest request){
        return request.getSession().getServletContext().getRealPath("");
    }

    /**
     * 根据不同的系统获取不同的字体文件
     * @return
     */
    public String getFontPath(){
        /**根据不同的系统获取不同的字体文件*/
        String osName=System.getProperty("os.name").toLowerCase();
        if(osName.indexOf("linux")>=0){
            templateFont=this.getClass().getResource("/").getPath() + "/template/act/simsun.ttf";
        }else if(osName.indexOf("win")>=0){
            templateFont=this.getClass().getResource("/").getPath() + "/template/act/simsun.ttc";
        }
        return templateFont;
    }

}
