package com.bcxin.wechat.bill.web;

import com.alibaba.fastjson.JSON;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.models.fee.entity.FeeSettlementMonth;
import com.bcxin.models.fee.service.FeeSettlementService;
import com.bcxin.models.fee.service.IFeeSettlementMonthService;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.wechat.bill.service.WXBillService;
import com.bcxin.wechat.util.CTLUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * liyongqiang
 * 账单模块
 * 2017-8-18
 */
@Controller
@RequestMapping("${weChatPath}/bill")
public class WXBillController extends BaseController {

    @Autowired
    WXBillService wxBillService;

    @Autowired
    IFeeSettlementMonthService feeSettlementMonthService;

    @RequestMapping("/index")
    public String index(@RequestParam Map<Object,Object> params , Model model){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        model.addAttribute("total",wxBillService.cntCompany(p)) ;
        p.put("month","true");
        model.addAttribute("row",wxBillService.cntCompany(p)) ;
        model.addAttribute("p",params) ;
        return "wechat/bill/bill_manager";
    }

    /**
     * 项目条件筛选 筛选页面
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/20 16:42
     */
    @RequestMapping("/bill-condition")
    public String billCondition(@RequestParam Map<Object,Object> params , Model model){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        model.addAttribute("p",params) ;
        return "wechat/bill/bill_condition";
    }

    /**
     * 项目条件筛选 城市
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/20 16:42
     */
    @RequestMapping("/bill-condition-city")
    public String billConditionCity(@RequestParam Map<Object,Object> params , Model model){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        model.addAttribute("p",params) ;
        return "wechat/bill/bill_condition_city";
    }

    /**
     * 项目条件筛选 机构
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/20 16:42
     */
    @RequestMapping("/bill-condition-company")
    public String billConditionCompany(@RequestParam Map<Object,Object> params , Model model){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        model.addAttribute("p",params) ;
        return "wechat/bill/bill_condition_company";
    }

    /**
     * 项目条件筛选 活动项目
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/20 16:42
     */
    @RequestMapping("/bill-condition-project")
    public String billConditionProject(@RequestParam Map<Object,Object> params , Model model){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        model.addAttribute("p",params) ;
        return "wechat/bill/bill_condition_project";
    }


    @RequestMapping("/list")
    public String list(@RequestParam Map<Object,Object> params , Model model){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        model.addAttribute("total",wxBillService.cntCompany(p)) ;
        model.addAttribute("p",params) ;
        return "wechat/bill/bill_list";
    }

    @RequestMapping("/detail/{id}")
    public String detail(@RequestParam Map<Object,Object> params , @PathVariable String id, Model model){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        model.addAttribute("p",params) ;
        p.put("id",id);
        model.addAttribute("row", JSON.toJSONStringWithDateFormat(wxBillService.queryById(p).get(0),"yyyy-MM-dd HH:mm:ss"));
        return "wechat/bill/bill_detail";
    }

    @RequestMapping("/detail/isPay/{orderNo}")
    public @ResponseBody Object isPay(@RequestParam Map<Object,Object> params , @PathVariable String orderNo, Model model){
        params.put("order_no",orderNo);
        return wxBillService.isPay(params);
    }

    /**
     * 获取月结单
     * @param params 传入 月份，产品类型，省份id，机构ID登录信息中获取
     */
    @RequestMapping("/getMonthFee")
    public @ResponseBody Object getMonthFee(@RequestParam Map<Object,Object> params , Model model){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        return feeSettlementMonthService.selectByCons(p);
    }

    /**
     * 获得某个月的 所有日结总收入
     * @param params 传入 月份，产品类型，省份id，机构ID登录信息中获取
     */
    @RequestMapping("/getListTotalFee")
    public @ResponseBody Object getListTotalFee(@RequestParam Map<Object,Object> params , Model model){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        return wxBillService.getListTotalFee(p);
    }

    @RequestMapping("/getListProvince")
    public @ResponseBody Object getListProvince(@RequestParam Map<Object,Object> params , Model model){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        return wxBillService.getListProvince(p);
    }

    /**
     * 账单分页查询
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/13 15:35
     */
    @RequestMapping("/weixinQueryBillList")
    public @ResponseBody Object weixinQueryBillList(@RequestParam Map<Object,Object> params , Model model){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        CTLUtil.out(wxBillService.weixinQueryBillList(p),getResponse());
        return null;
    }

    @RequestMapping("/getProductTypeByCompanyId")
    public @ResponseBody Object getProductTypeByCompanyId(@RequestParam Map<Object,Object> params , Model model){
        Map<Object,Object> p = CTLUtil.init(getRequest(),params);
        CTLUtil.out(wxBillService.getProductTypeByCompanyId(p),getResponse());
        return null;
    }


    /**
     * 获得登录的资源方和分销商的下级分销商
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/11 16:23
     */
    @RequestMapping(value = "/query-sum-belwo-bill")
    public @ResponseBody Object querySumBelowBill(@RequestParam Map<Object,Object> params , Model model){
        Map p = CTLUtil.init(getRequest(),params);
        CTLUtil.out(wxBillService.querySumBelowBill(p),getResponse());
        return null;
    }


    /**
     * 获得登录的资源方和分销商的下级分销商
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/11 16:23
     */
    @RequestMapping(value = "/get-low-level-company-by-current-company")
    public @ResponseBody Object getLowLevelCompanyByCurrentCompany(@RequestParam Map<Object,Object> params , Model model){
        Map p = CTLUtil.init(getRequest(),params);
        CTLUtil.out(wxBillService.getLowLevelCompanyByCurrentCompany(p),getResponse());
        return null;
    }

    /**
     * 获得登录的分销商对应的被分配的城市信息
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/11 16:23
     */
    @RequestMapping(value = "/get-area-info")
    public @ResponseBody Object getCityInfo(@RequestParam Map<Object,Object> params , Model model){
        Map p = CTLUtil.init(getRequest(),params);
        CTLUtil.out(wxBillService.getAreaInfo(p),getResponse());
        return null;
    }

    /**
     * 返回项目信息从账单关联订单后的列表信息中获取
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/11 16:23
     */
    @RequestMapping(value = "/get-project-from-bill")
    public @ResponseBody Object getProjectFromBill(@RequestParam Map<Object,Object> params , Model model){
        Map p = CTLUtil.init(getRequest(),params);
        //CTLUtil.out(wxBillService.getProjectFromBill(p),getResponse());
        //2018-05-14 修改为以下获取方式
        CTLUtil.out(wxBillService.selectProjectNameByOrderList(p),getResponse());
        return null;
    }

    /**
     * 返回项目信息从账单关联订单后的列表信息中获取
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/11 16:23
     */
    @RequestMapping(value = "/get-total-income")
    public @ResponseBody Object getTotalIncome(@RequestParam Map<Object,Object> params , Model model){
        Map p = CTLUtil.init(getRequest(),params);
        CTLUtil.out(wxBillService.cntCompany(p),getResponse());
        return null;
    }





}
