package com.bcxin.wechat.bill.service;

import java.util.List;
import java.util.Map;

/**
 * 微信端-收入管理- 公用接口类
 * @author  hzp
 * @date 2016/05/16
 */
public interface WxBillCommonService {

    /**
     * 获取当前分销机构信息+ 机构下级分销商信息
     * @param map 当前分销商机构id
     * @return 分销商机构信息列表
     */
    List<Map<String,Object>> selectDistributionWithLower(Map<Object,Object> map);

    /**
     * 根据资源方id查询销售区域下的所有分销商
     * @param map 资源方机构id
     * @return 分销商机构信息列表
     */
    List<Map<String,Object>> selectDistributionByResource(Map<Object,Object> map);

    /**
     * 根据机构id 查询对应销售区域省份
     * @param map
     * @return 返回省
     */
    List<Map<String,Object>> selectSellAreaProvinceById(Map<Object,Object> map);

    /**
     * 根据机构id 查询对应销售区域市、县
     * @param map
     * @return 返回省、市、县
     */
    List<Map<String,Object>> selectSellAreaCityById(Map<Object,Object> map);

    /**
     * 根据机构id查询对应销售区域
     * @param map
     * @return 返回省、市、县、区域
     */
    List<Map<String,Object>> selectSellAreaDistrictById(Map<Object,Object> map);

    /**
     * 获取订单的项目活动信息
     * @param params
     * @return
     */
    List<Map<String,Object>> selectProjectNameByOrderList(Map<Object,Object> params);
}
