package com.bcxin.wechat.bill.entity;

import com.bcxin.enums.PayStatusEnum;
import com.bcxin.enums.ProductTypeEnum;
import com.bcxin.mybatisplus.toolkit.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 微信端-收入明细-日结单列表视图
 * @author hzp
 */
public class BillOrderView implements Serializable {
    /**分期数默认值*/
    private String stagesNumDefault="1";

    /**订单有效开始日期*/
    private String startDate;
    /**订单有效结束日期*/
    private String endDate;
    /**订单支付日期*/
    private String payDate;
    /**订单日期*/
    private String orderDate;
    /**项目名称*/
    private String projectName;
    /**订单金额*/
    private BigDecimal orderAmount;
    /**订单编号*/
    private String orderNo;
    /**订单表主键*/
    private String orderId;
    /**订单分期数*/
    private String stagesNum;
    /**是否分期*/
    private String stagesName;
    /**订单支付状态 PayStatusEnum*/
    private String payStatus;
    /**支付状态名称*/
    private String payStatusName;
    /**产品id*/
    private String productId;
    /**产品类型 @see ProductTypeEnum*/
    private String productType;
    /**产品分类名称*/
    private String productTypeName;
    /**产品名称*/
    private String productName;
    /**本级机构类型 @see CompanyTypeEnum*/
    private String currCompanyType;
    /**本级机构id*/
    private String companyId;
    /**本级机构名称*/
    private String companyName;
    /**本级机构对应产品费率*/
    private BigDecimal currFee;
    /**本级机构订单收入金额*/
    private BigDecimal currOrderAmount=BigDecimal.ZERO;
    /**本级机构所得佣金（净收入）,扣除下级佣金后的金额*/
    private BigDecimal currAmount=BigDecimal.ZERO;
    /**当前分销等级 @see DistributorLevelEnum*/
    private String currLevel;
    /**下级分销等级*/
    private String lowerLevel;
    /**下级机构id*/
    private String lowerCompanyId;
    /**下级机构名称*/
    private String lowerCompanyName;
    /**下级机构对应产品费率*/
    private String lowerFee;
    /**下级机构订单收入金额*/
    private BigDecimal lowerOrderAmount=BigDecimal.ZERO;
    /**下级机构所得佣金*/
    private BigDecimal lowerAmount=BigDecimal.ZERO;

    /**来源分销商id*/
    private String sourceDistributorId;
    /**来源分销商名称*/
    private String sourceCompanyName;

    /**订单核销状态*/
    private String cancellStatus;
    /**订单月结状态 0 未结算 1 结算*/
    private String monthStatus;

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getPayDate() {
        return payDate;
    }

    public void setPayDate(String payDate) {
        this.payDate = payDate;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public BigDecimal getOrderAmount() {
        return orderAmount;
    }

    public void setOrderAmount(BigDecimal orderAmount) {
        this.orderAmount = orderAmount;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
        if(StringUtils.isNotEmpty(productType)){
            this.setProductTypeName(ProductTypeEnum.getAlias(productType));
        }
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getCurrCompanyType() {
        return currCompanyType;
    }

    public void setCurrCompanyType(String currCompanyType) {
        this.currCompanyType = currCompanyType;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public BigDecimal getCurrFee() {
        return currFee;
    }

    public void setCurrFee(BigDecimal currFee) {
        this.currFee = currFee;
    }

    public BigDecimal getCurrOrderAmount() {
        return currOrderAmount;
    }

    public void setCurrOrderAmount(BigDecimal currOrderAmount) {
        this.currOrderAmount = currOrderAmount;
    }

    public BigDecimal getCurrAmount() {
        return currAmount;
    }

    public void setCurrAmount(BigDecimal currAmount) {
        this.currAmount = currAmount;
    }

    public String getCurrLevel() {
        return currLevel;
    }

    public void setCurrLevel(String currLevel) {
        this.currLevel = currLevel;
    }

    public String getLowerCompanyId() {
        return lowerCompanyId;
    }

    public void setLowerCompanyId(String lowerCompanyId) {
        this.lowerCompanyId = lowerCompanyId;
    }

    public String getLowerCompanyName() {
        return lowerCompanyName;
    }

    public void setLowerCompanyName(String lowerCompanyName) {
        this.lowerCompanyName = lowerCompanyName;
    }

    public String getLowerFee() {
        return lowerFee;
    }

    public void setLowerFee(String lowerFee) {
        this.lowerFee = lowerFee;
    }

    public BigDecimal getLowerOrderAmount() {
        return lowerOrderAmount;
    }

    public void setLowerOrderAmount(BigDecimal lowerOrderAmount) {
        this.lowerOrderAmount = lowerOrderAmount;
    }

    public BigDecimal getLowerAmount() {
        return lowerAmount;
    }

    public void setLowerAmount(BigDecimal lowerAmount) {
        this.lowerAmount = lowerAmount;
    }

    public String getSourceDistributorId() {
        return sourceDistributorId;
    }

    public void setSourceDistributorId(String sourceDistributorId) {
        this.sourceDistributorId = sourceDistributorId;
    }

    public String getSourceCompanyName() {
        return sourceCompanyName;
    }

    public void setSourceCompanyName(String sourceCompanyName) {
        this.sourceCompanyName = sourceCompanyName;
    }

    public String getCancellStatus() {
        return cancellStatus;
    }

    public void setCancellStatus(String cancellStatus) {
        this.cancellStatus = cancellStatus;
    }

    public String getMonthStatus() {
        return monthStatus;
    }

    public void setMonthStatus(String monthStatus) {
        this.monthStatus = monthStatus;
    }

    public String getOrderDate() {
        return orderDate;
    }

    public void setOrderDate(String orderDate) {
        this.orderDate = orderDate;
    }

    public String getLowerLevel() {
        return lowerLevel;
    }

    public void setLowerLevel(String lowerLevel) {
        this.lowerLevel = lowerLevel;
    }

    public String getStagesNum() {
        return stagesNum;
    }

    public void setStagesNum(String stagesNum) {
        this.stagesNum = stagesNum;
        if(stagesNumDefault.equals(stagesNum)){
            this.setStagesName("否");
        }else{
            this.setStagesName("分"+stagesNum+"期");
        }
    }

    public String getProductTypeName() {
        return productTypeName;
    }

    public void setProductTypeName(String productTypeName) {
        this.productTypeName = productTypeName;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(String payStatus) {
        this.payStatus = payStatus;
        if(StringUtils.isNotEmpty(payStatus)){
            this.setPayStatusName(PayStatusEnum.getAlias(payStatus));
        }
    }

    public String getPayStatusName() {
        return payStatusName;
    }

    public void setPayStatusName(String payStatusName) {
        this.payStatusName = payStatusName;
    }

    public String getStagesName() {
        return stagesName;
    }

    public void setStagesName(String stagesName) {
        this.stagesName = stagesName;
    }
}
