package com.bcxin.wechat.bill.dao;

import com.bcxin.core.base.dao.BasDao;
import com.bcxin.models.order.entity.OrderForm;
import com.bcxin.spring.annotation.MyBatisDao;
import com.bcxin.wechat.bill.entity.BillOrderTotalView;
import com.bcxin.wechat.bill.entity.BillOrderView;

import java.util.List;
import java.util.Map;

/**
 * 微信端-收入管理-日结订单 Dao接口
 * @author  hzp
 * @date 2016/05/16
 */
@MyBatisDao
public interface WxBillNewMapper extends BasDao<OrderForm> {

    /***************************************分销商***************************************/

    /**
     * 查询当前分销商订单收入明细记录数-分页使用
     * @param map
     * @return 分销商-日结订单明细列表记录总数
     */
    int selectDistributorBillOrderPageCount(Map<Object,Object> map);

    /**
     * 查询当前分销商订单收入明细
     * @param map
     * @return 分销商-日结订单明细列表
     */
    List<BillOrderView> selectDistributorBillOrderPage(Map<Object,Object> map);

    /**
     * 统计当前分销商订单收入
     * @param map
     * @return 分销商-日结订单汇总明细
     */
    BillOrderTotalView selectDistributorBillOrderTotal(Map<Object,Object> map);

    /**
     * 根据产品分类汇总订单信息
     * @param map
     * @return 分销商-产品汇总明细
     */
    List<BillOrderTotalView> selectDistributorBillOrderTotalByProduct(Map<Object,Object> map);


    /***************************************资源方*****************************************/

    /**
     * 查询当前分销商订单收入明细记录数-分页使用
     * @param map
     * @return 分销商-日结订单明细列表记录总数
     */
    int selectResourceBillOrderPageCount(Map<Object,Object> map);

    /**
     * 查询当前资源方订单收入明细
     * @param map
     * @return 资源方-日结订单明细列表
     */
    List<BillOrderView> selectResourceBillOrderPage(Map<Object,Object> map);

    /**
     * 统计当前资源方订单收入
     * @param map
     * @return 资源方-日结订单汇总明细
     */
    BillOrderTotalView selectResourceBillOrderTotal(Map<Object,Object> map);

    /**
     * 根据产品分类汇总订单信息
     * @param map
     * @return 资源方-产品汇总明细
     */
    List<BillOrderTotalView> selectResourceBillOrderTotalByProduct(Map<Object,Object> map);

    /**
     * 查询订单详情
     * @param map
     * @return
     */
    List<BillOrderView> selectDistributorOrderDetail(Map<Object,Object> map);

    /**
     * 查询订单支付状态
     * @param orderNo
     * @return
     */
    Map<String,Object> selectOrderPayStatus(String orderNo);


}
