package com.bcxin.wechat.bill.dao;

import com.bcxin.core.base.dao.BasDao;
import com.bcxin.models.order.entity.OrderForm;
import com.bcxin.spring.annotation.MyBatisDao;

import java.util.List;
import java.util.Map;

/**
 * Created by Apple on 2017/8/21.
 */
@MyBatisDao
public interface WXBillMapper extends BasDao<OrderForm> {

    /**
     * 微信查询账单信息分页,（废弃）
     */
    List<Map<Object,Object>> query(Map<Object,Object> p);
    int queryCnt(Map<Object,Object> p);

    List<Map<Object,Object>> queryById(Map<Object,Object> p);

    List<Map<Object,Object>> queryByOrderNo(Map<Object,Object> p);

    List<Map<Object,Object>> cntCompany(Map<Object,Object> p);

    List<Map<Object,Object>> getListProvince(Map<Object,Object> p);
    List<Map<Object,Object>> getListProvinceAll(Map<Object,Object> p);


    Map<Object,Object> getListTotalFee(Map<Object,Object> p);

    /**
     * 根据分销商机构ID 获得对应的产品类型
     * @param p  用户登录的机构ID
     * @return
     */
    List<Map<Object,Object>> getProductTypeByCompanyId(Map<Object,Object> p);

    /**
     * 获得登录的下级分销商
     * @apiNote 作者 陈堂君
     * @since 创建于 2018/4/11 16:23
     */
    List<Map> getLowLevelCompanyByCurrentCompany(Map p);

    /**
     * 获得登录的分销商对应的被分配的城市信息
     * @apiNote 作者 陈堂君
     * @since 创建于 2018/4/12 16:49
     */
    List<Map> getCityInfo(Map p);

    /**
     * 获得登录的分销商对应的被分配的城市信息
     * @apiNote 作者 陈堂君
     * @since 创建于 2018/4/12 16:49
     */
    List<Map> getProvinceInfo(Map p);

    /**
     * 微信查询账单信息分页
     * @apiNote 作者 陈堂君
     * @since 创建于 2018/4/12 16:49
     */
    List<Map> weixinQueryBillList(Map p);
    int weixinQueryBillListCnt(Map p);

    /**
     * 返回项目信息从账单关联订单后的列表信息中获取
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/13 16:02
     */
    List<Map> getProjectFromBill(Map p);

    /**
     * 查询下级账单的总值
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/5/4 上午9:21
     * @param p
     * @return
     */
    List<Map> querySumBelowBill(Map p);


    List<Map> isProvinceNoLimit(Map p);
    List<Map> getAllProvince(Map p);
    List<Map> getAllCity(Map p);

    /**
     * 根据订单列表查询项目名称
     * @param p
     * @return
     */
    List<Map> selectProjectNameByOrderList(Map p);

}
