package com.bcxin.wechat.activity.web;

import com.bcxin.core.base.web.BaseController;
import com.bcxin.core.util.BusinessException;
import com.bcxin.models.product.service.ProductInsService;
import com.bcxin.wechat.activity.service.impl.WeChatExhibitionServiceImpl;
import com.bcxin.wechat.product.service.WeiXinProductService;
import com.bcxin.wechat.util.CTLUtil;
import com.bcxin.wechat.util.Result;
import com.xiaoleilu.hutool.convert.Convert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;


/**
 * 展责险，展厅展位接口
 * @apiNote  作者 陈堂君  
 * @since 创建于 2018/4/11 10:32
 */
@Controller
@RequestMapping("${weChatPath}/exhibition")
public class WeChatExhibitionController extends BaseController {

    @Autowired
    private ProductInsService  productInsService;

    @Autowired
    private WeiXinProductService   weiXinProductService;

    @Autowired
    private WeChatExhibitionServiceImpl weChatExhibitionService;

    /**
     * 新增展会页面
     */
    @RequestMapping("/exhibition-add-view")
    public String exhibitionAdd(@RequestParam Map<Object,Object> params, Model model, HttpServletRequest req) {
        model.addAttribute("p",params);
        return "wechat/activity/exhibition_add";
    }

    /**
     * 展会详情页面
     */
    @RequestMapping("/exhibition-detail-view")
    public String exhibitionDetail(@RequestParam Map<Object,Object> params, Model model, HttpServletRequest req) {
        params.put("activity_id",params.get("activityId"));
        Result res = weChatExhibitionService.getActivityExhibitions(params);
        model.addAttribute("p",params);
//        model.addAttribute("json",res.getData());
        return "wechat/activity/exhibition_detail";
    }

    /**
     * 展厅展位搜索页面
     */
    @RequestMapping("/exhibition-search-view")
    public String exhibitionSearch(@RequestParam Map<Object,Object> params, Model model, HttpServletRequest req) {
        model.addAttribute("p",params);
        return "wechat/activity/exhibition_search";
    }

    /**
     * 得到展会的展位展厅详情
     */
    @RequestMapping("/get-activity-exhibitions")
    public  @ResponseBody Result getActivityExhibitions(@RequestParam Map<Object,Object> params, Model model, HttpServletRequest req) {
        Map<Object, Object> p = CTLUtil.init(getRequest(), params);
        return weChatExhibitionService.getActivityExhibitions(p);
    }



    /**
     * 新增和修改展厅数据，在编辑时用
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/11 9:09
     */
    @RequestMapping("/save-exhibition")
    public @ResponseBody Result saveExhibition(@RequestParam Map<Object, Object> params) throws BusinessException{
        Map<Object, Object> p = CTLUtil.init(getRequest(), params);
        return weChatExhibitionService.saveExhibition(p);
    }
    /**
     * 删除展厅数据，在编辑时用
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/11 9:09
     */
    @RequestMapping("/del-exhibition")
    public @ResponseBody Result delExhibition(@RequestParam Map<Object, Object> params) throws BusinessException {
        Map<Object, Object> p = CTLUtil.init(getRequest(), params);
        return weChatExhibitionService.delExhibition(p);
    }


    /**
     * 修改单个展位数据，在编辑时用
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/11 9:09
     */
    @RequestMapping("/save-exhibition-pos-single")
    public @ResponseBody Result saveExhibitionPosSingle(@RequestParam Map<Object, Object> params) throws BusinessException {
        Map<Object, Object> p = CTLUtil.init(getRequest(), params);
        return weChatExhibitionService.saveExhibitionPosSingle(p);
    }

    /**
     * 批量新增展厅展位数据，在编辑时用
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/11 9:10
     */
    @RequestMapping("/insert-exhibition-pos-batch")
    public @ResponseBody Result insertExhibitionPos(@RequestParam Map<Object, Object> params) throws BusinessException {
        Map<Object, Object> p = CTLUtil.init(getRequest(), params);
        return weChatExhibitionService.insertExhibitionPos(p);
    }

    /**
     * 删除展厅展位数据，在编辑时用
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/11 9:10
     */
    @RequestMapping("/del-exhibition-pos")
    public @ResponseBody Result delExhibitionPos(@RequestParam Map<Object, Object> params) throws BusinessException {
        Map<Object, Object> p = CTLUtil.init(getRequest(), params);
        return weChatExhibitionService.delExhibitionPos(p);
    }



//    /**
//     * 保存某个活动的展厅和展位的关系数据，在编辑时加展厅用
//     * @apiNote  作者 陈堂君
//     * @since 创建于 2018/4/11 9:10
//     */
//    @RequestMapping("/save-activity-sel-hall-pos")
//    public @ResponseBody Result saveActivitySelHallPos(@RequestParam Map<Object, Object> params) throws BusinessException{
//        Map<Object, Object> p = CTLUtil.init(getRequest(), params);
//        return weChatExhibitionService.insertExhibitionPos(p);
//    }


}
