package com.bcxin.wechat.activity.service.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.core.util.BusinessException;
import com.bcxin.mybatisplus.toolkit.IdWorker;
import com.bcxin.util.toolbox.StrUtil;
import com.bcxin.wechat.activity.dao.WeChatExhibitionMapper;
import com.bcxin.wechat.activity.entity.ExhibitionHall;
import com.bcxin.wechat.activity.entity.ExhibitionHallPos;
import com.bcxin.wechat.activity.service.ExhibitionHallPosService;
import com.bcxin.wechat.activity.service.ExhibitionHallService;
import com.bcxin.wechat.util.Result;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xiaoleilu.hutool.bean.BeanUtil;
import com.xiaoleilu.hutool.collection.CollUtil;
import com.xiaoleilu.hutool.convert.Convert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 微信端，展示内容
 * Created by Apple on 2017/8/23.
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class WeChatExhibitionServiceImpl{
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    WeChatExhibitionMapper weChatExhibitionMapper;
    @Autowired
    ExhibitionHallService exhibitionHallService;
    @Autowired
    ExhibitionHallPosService exhibitionHallPosService;

    /**
     * 查询活动的信息，通过活动ID进行查询
     * @apiNote  作者 陈堂君  
     * @since 创建于 2018/4/10 14:03
     */
    public Map getActivityInfoById(String id) {
        return weChatExhibitionMapper.getActivityInfoById(id);
    }

    /**
     * 保存展厅的数据
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/10 14:44
     * @return 返回保存成功的ID
     */
    public Result saveExhibition(Map<Object, Object> p) throws BusinessException{
        ExhibitionHall exhibitionHall = BeanUtil.mapToBean(p, ExhibitionHall.class,true);
        if(p.get("exhibition_hall_id")==null){
            exhibitionHall.setCreate_by(Convert.toLong(p.get("weixin_login_user_id")));
            exhibitionHall.setCreate_time(new Date());
            exhibitionHall.setExhibition_hall_id(IdWorker.getId());
            exhibitionHall.setSys_company_id(Convert.toLong(p.get("weixin_login_company_id")));
//            //默认新增一条展位记录
//            ExhibitionHallPos exhibitionHallPos = new ExhibitionHallPos();
//            exhibitionHallPos.setExhibition_hall_id(exhibitionHall.getExhibition_hall_id());
//            exhibitionHallPos.setExhibition_pos_name("OK001");
//            exhibitionHallPos.setCreate_time(new Date());
//            exhibitionHallPos.setCreate_by(Convert.toLong(p.get("weixin_login_user_id")));
//            exhibitionHallPos.setDel_flag(0);
//            exhibitionHallPosService.insert(exhibitionHallPos); //初始化一条展位数据，以防页面出错
        }else{
            exhibitionHall.setUpdate_by(Convert.toLong(p.get("weixin_login_user_id")));
            exhibitionHall.setUpdate_time(new Date());
        }
        exhibitionHallService.insertOrUpdate(exhibitionHall);

        List<Map> repeatList = weChatExhibitionMapper.getExhibitionRepeatHallName(exhibitionHall.getExhibition_hall_name(),exhibitionHall.getActivity_id());
        if(repeatList.size()>0){
            throw new BusinessException("WARN-00001","展厅名重复，本次提交失败");
        }

        return Result.success(Result.SUCCESS_MSG, exhibitionHall.getExhibition_hall_id()+"");
    }


    /**
     * 删除展厅
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/19 19:32
     */
    public Result delExhibition(Map<Object, Object> p) throws  BusinessException{
        //判断展厅下是否有展位购买
        List<Map> repeatList =weChatExhibitionMapper.getInsPosCntByHall(Convert.toLong(p.get("exhibition_hall_id")));
        if(repeatList.size()>0){
            throw new BusinessException("WARN-00002","展厅已经有展位投保，不可删除，本次提交失败");
        }
        ExhibitionHall exhibitionHall = new ExhibitionHall();
        exhibitionHall.setExhibition_hall_id(Convert.toLong(p.get("exhibition_hall_id")));
        exhibitionHall.setDel_flag(1);
        exhibitionHallService.updateById(exhibitionHall);
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * 插入展厅的展位数据
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/10 15:10
     * @param p exhibition_hall_id ,exhibition_pos_names A1,A3,A4,,A5 逗号隔开的展位名称
     */
    public Result insertExhibitionPos(Map<Object, Object> p) throws BusinessException{
        List<String> list = StrUtil.split2List(String.valueOf(p.get("exhibition_pos_names")),',');
        List<ExhibitionHallPos> dataList = Lists.newArrayList();
        list.forEach(each ->{
            ExhibitionHallPos rec = new ExhibitionHallPos();
            rec.setCreate_time(new Date());
            rec.setCreate_by(Convert.toLong(p.get("weixin_login_user_id")));
            rec.setDel_flag(0);
            rec.setExhibition_pos_name(each);
            rec.setExhibition_hall_pos_id(IdWorker.getId());
            rec.setExhibition_hall_id(Convert.toLong(p.get("exhibition_hall_id")));
//            rec.setActivity_id(Convert.toLong(p.get("activity_id")));
            dataList.add(rec);
        });
        exhibitionHallPosService.insertBatch(dataList);

        //某个展厅展位名称不能重复的判断
//        List<Map> repeatList = weChatExhibitionMapper.getExhibitionRepeatPosName(Convert.toLong(p.get("exhibition_hall_id")),list);
        // modify by hzp 2018/05/31 修改为根据活动验证展位的唯一性
        List<Map> repeatList = weChatExhibitionMapper.getExhibitionRepeatPos(Convert.toLong(p.get("activity_id")),list);
        if(repeatList.size()>0){
            throw new BusinessException("WARN-00001","展厅展位名重复，本次提交失败");
        }
        return Result.success(Result.SUCCESS_MSG);
    }


    /**
     * 删除展厅的展位数据
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/10 16:46
     * @param p exhibition_hall_pos_ids 1,2,3,4 逗号隔开的展位名称
     */
    public Result delExhibitionPos(Map<Object, Object> p) {
        List<String> list = StrUtil.split2List(String.valueOf(p.get("exhibition_hall_pos_ids")),',');
        weChatExhibitionMapper.delExhibitionPos(Convert.toLong(p.get("exhibition_hall_id")),list);
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * 得到最近的展会活动信息
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/11 9:58
     * @param p 登录的机构ID weixin_login_company_id
     */
    public Result getLastActivityExhibitions(Map<Object,Object> p){
        List<Map> list = weChatExhibitionMapper.getLastActivityExhibitions(p);
        Map resultMap = Maps.newHashMap();
        list.forEach(rec ->{
            resultMap.put(rec.get("exhibition_hall_name"), Lists.newArrayList());
            ((List)resultMap.get(rec.get("exhibition_hall_name"))).add(rec);
        });
        return Result.success(Result.SUCCESS_MSG, resultMap);
    }

    /**
     * 得到展会活动的展位信息，包含投保
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/11 9:58
     * @param p 活动 activity_id
     */
    public Result getActivityExhibitions(Map<Object,Object> p){
        List<Map> list = weChatExhibitionMapper.getActivityExhibitions(p);
        return Result.success(Result.SUCCESS_MSG, list);
    }

    /**
     * 新增和修改单个展位数据，在编辑时用
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/16 19:30
     * @param p
     * @return
     */
    public Result saveExhibitionPosSingle(Map<Object, Object> p) throws BusinessException{
        ExhibitionHallPos rec = BeanUtil.mapToBean(p, ExhibitionHallPos.class,true);
        if(p.get("exhibition_hall_pos_id")==null){
            rec.setCreate_time(new Date());
            rec.setCreate_by(Convert.toLong(p.get("weixin_login_user_id")));
            rec.setExhibition_hall_pos_id(IdWorker.getId());
        }else{
            rec.setUpdate_by(Convert.toLong(p.get("weixin_login_user_id")));
            rec.setUpdate_time(new Date());
            rec.setExhibition_hall_pos_id(Convert.toLong(p.get("exhibition_hall_pos_id")));
        }
//        rec.setDel_flag(0);
        rec.setExhibition_pos_name(Convert.toStr(p.get("exhibition_pos_name")));
//        rec.setExhibition_hall_id(Convert.toLong(p.get("exhibition_hall_id")));
//        rec.setActivity_id(Convert.toLong(p.get("activity_id")));
        exhibitionHallPosService.insertOrUpdate(rec);

        //某个展厅展位名称不能重复的判断
        List<String> list = CollUtil.newArrayList();
        list.add(rec.getExhibition_pos_name());
        //List<Map> repeatList = weChatExhibitionMapper.getExhibitionRepeatPosName(Convert.toLong(p.get("exhibition_hall_id")),list);
        //modify by hzp 2018/05/31 修改为根据活动验证展位的唯一性
        List<Map> repeatList = weChatExhibitionMapper.getExhibitionRepeatPos(Convert.toLong(p.get("activity_id")),list);
        if(repeatList.size()>0){
            throw new BusinessException("WARN-00001","展厅展位名重复，本次提交失败");
        }
        return Result.success(Result.SUCCESS_MSG, null);
    }


}
