package com.bcxin.wechat.activity.service.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.core.base.service.impl.BaseServiceImpl;
import com.bcxin.core.entity.SysCompany;
import com.bcxin.core.util.BusinessException;
import com.bcxin.mybatisplus.toolkit.IdWorker;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.bcxin.util.toolbox.DateUtil;
import com.bcxin.util.toolbox.StrUtil;
import com.bcxin.wechat.activity.dao.WeCharActivityMapper;
import com.bcxin.wechat.activity.dao.WeChatExhibitionMapper;
import com.bcxin.wechat.activity.entity.ExhibitionHall;
import com.bcxin.wechat.activity.entity.ExhibitionHallPos;
import com.bcxin.wechat.activity.entity.WeCharActivity;
import com.bcxin.wechat.activity.service.ExhibitionHallPosService;
import com.bcxin.wechat.activity.service.ExhibitionHallService;
import com.bcxin.wechat.activity.service.WeCharActivityService;
import com.bcxin.wechat.util.PageResult;
import com.bcxin.wechat.util.R;
import com.google.common.collect.Lists;
import com.xiaoleilu.hutool.convert.Convert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Apple on 2017/8/23.
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class WeCharActivityServiceImpl   extends BaseServiceImpl<WeCharActivityMapper,WeCharActivity> implements WeCharActivityService{

    @Autowired
    ExhibitionHallService exhibitionHallService;
    @Autowired
    ExhibitionHallPosService exhibitionHallPosService;
    @Autowired
    WeChatExhibitionMapper weChatExhibitionMapper;

    @Override
    public Map<String,Object> saveActivity( Map<Object, Object> p) throws Exception {
        Map<String,Object> map= new HashMap<>();
        String title=p.get("activityName")==null?null:p.get("activityName").toString();
        String startTime=p.get("startTime")==null?null:p.get("startTime").toString();
        String endTime=p.get("endTime")==null?null:p.get("endTime").toString();
        String province=p.get("province")==null?null:p.get("province").toString();
        String city=p.get("city")==null?null:p.get("city").toString();
        String district=p.get("district")==null?null:p.get("district").toString();
        String address=p.get("address")==null?null:p.get("address").toString();
        if(StringUtils.isEmpty(title)||StringUtils.isEmpty(startTime)||StringUtils.isEmpty(endTime)){
           map.put("status",false);
           map.put("msg","操作失败,数据不能验证");
           return  map;
//           return  new R(false,"操作失败,数据不能验证");
        }
        String id=p.get("id")==null?null:p.get("id").toString();
        WeCharActivity  activity =null;
        if(id==null){
            activity= new WeCharActivity();
        }else{
            activity=dao.selectById(id);
        }
        activity.setUserId(p.get("weixin_login_company_id").toString());
        activity.setSysCompany(new SysCompany(Long.parseLong(p.get("weixin_login_company_id").toString())));
        activity.setActivityName(title);
        activity.setStartTime(DateUtil.parse(startTime,"yyyy-MM-dd"));
        activity.setEndTime(DateUtil.parse(endTime,"yyyy-MM-dd"));
        activity.setProvince(province);
        activity.setCity(city);
        activity.setDistrict(district);
        activity.setAddress(address);
        activity.setStatus(1);//1启用 0禁用
        this.save(activity);

        //保存活动对应的展厅和展位信息
        //[{exhibition_hall_name:"xxx", exhibition_hall_pos_names:A01,A02,A03,A04},{exhibition_hall_name:"yyy", exhibition_hall_pos_names:A01,A02,A03,A04}]
        String prompt = "";
        if(p.get("exhibitions")!=null && !"[]".equals(p.get("exhibitions"))){
            List<Map> exhibitions = JSON.parseArray(Convert.toStr(p.get("exhibitions")),Map.class);
            List<ExhibitionHall> listHall = Lists.newArrayList();
            List<ExhibitionHallPos> listHallPos = Lists.newArrayList();
            for(Map rec : exhibitions){
                ExhibitionHall hall = new ExhibitionHall();
                hall.setExhibition_hall_id(IdWorker.getId());
                hall.setCreate_time(new Date());
                hall.setCreate_by(Convert.toLong(p.get("weixin_login_user_id")));
                hall.setDel_flag(0);
                hall.setSys_company_id(Convert.toLong(p.get("weixin_login_company_id")));
                hall.setExhibition_hall_name(Convert.toStr(rec.get("exhibition_hall_name")));
                hall.setActivity_id(activity.getId());
                listHall.add(hall); //展厅数据
                List<String> poses = StrUtil.split2List(Convert.toStr(rec.get("exhibition_hall_pos_names")),',');
                poses.forEach(posName ->{
                    ExhibitionHallPos hallPos = new ExhibitionHallPos();
                    hallPos.setExhibition_hall_id(hall.getExhibition_hall_id());
                    hallPos.setDel_flag(0);
                    hallPos.setCreate_by(Convert.toLong(p.get("weixin_login_user_id")));
                    hallPos.setCreate_time(new Date());
                    hallPos.setExhibition_hall_pos_id(IdWorker.getId());
                    hallPos.setExhibition_pos_name(posName);
                    listHallPos.add(hallPos); //展位数据
                });
            };
            //插入展会数据
            exhibitionHallService.insertBatch(listHall);
            exhibitionHallPosService.insertBatch(listHallPos);
            //第一次除重复判断
            List<Map> repeatHallList = weChatExhibitionMapper.getExhibitionRepeatHallNameInit(activity.getId());
            List<Map> repeatHallPosList = weChatExhibitionMapper.getExhibitionRepeatPosNameInit(activity.getId());
            if(repeatHallList.size()>0){
                for(Map each : repeatHallList){
                    prompt += each.get("exhibition_hall_name")+",";
                }
                throw new BusinessException("WARN-00001","展厅名重复，本次提交失败。"+prompt);
            }else if(repeatHallPosList.size()>0){
                prompt="";
                for(Map each : repeatHallList){
                    prompt += each.get("exhibition_hall_name")+"-"+each.get("exhibition_pos_name") + ",";
                }
                throw new BusinessException("WARN-00002","展位名重复，本次提交失败");
            }
        }

        map.put("status",true);
        map.put("msg","操作成功");
        map.put("id",activity.getId()+"");
        return map;
    }


    @Override
    public PageResult queryActivityListOfflineData(Map<Object, Object> p) {
        p.put("status",0);//禁用
        return new PageResult(dao.queryCnt(p), dao.query(p));
    }

    @Override
    public PageResult queryActivityListOnlineData(Map<Object, Object> p) {
        p.put("status",1);//正常
        return new PageResult(dao.queryCnt(p), dao.query(p));
    }

    @Override
    public R saveActivityStatus(HttpServletRequest req, Map<Object, Object> p) {

        String id=p.get("id")==null?null:p.get("id").toString();
        String status=p.get("status")==null?null:p.get("status").toString();
        if(StringUtils.isEmpty(id)||StringUtils.isEmpty(status)){
            return new R(false, "操作失败");
        }
        WeCharActivity  activity=dao.selectById(id);
        activity.setStatus(Integer.parseInt(status));//1启用 0禁用
        activity.setUpdateTime(new Date());
        this.save(activity);
        return new R(true, "操作成功");
    }

    @Override
    public R saveExpiredActivityList(String date) {

        List<WeCharActivity> list =dao.getExpiredList(date);
        if(list.size()>0){
            for (WeCharActivity activity : list) {
                //判断状态是否是过期，如果不是过期，改为过期
                activity.setStatus(2);//设置状态过期
            }
            this.updateBatchById(list);
        }
        return new R(true, "操作成功");
    }

    /**
     * 获得活动信息，并且增加展位活动信息
     * @param id
     * @return
     */
    @Override
    public Map<String, Object> getActivity(String id) {
        Map<String,Object> map = dao.getActivity(id);
        map.put("exhibitions",dao.getActivityExhibitions(id));
        return map;
    }


}
