package com.bcxin.wechat.activity.entity;

import com.bcxin.core.base.entity.DataEntity;
import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableName;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;


@TableName("activity_exhibition")
public class WeCharActivity extends DataEntity<WeCharActivity> implements Serializable {

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;


    @TableField(value = "activity_name")
    @NotNull(message = "活动名称不能为空")
    private String activityName;



    @TableField(value = "start_time")
    @NotNull(message = "活动开始时间不能为空")
    private Date startTime;


    @TableField(value = "end_time")
    @NotNull(message = "活动结束时间不能为空")
    private Date endTime;

    @TableField(value = "province")
    private String province;


    @TableField(value = "city")
    private String city;


    @TableField(value = "district")
    private String district;


    @TableField(value = "address")
    private String address;


    @TableField(value = "user_id")
    private String userId;


    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}
