package com.bcxin.wechat.activity.dao;

import com.bcxin.mybatisplus.mapper.BaseMapper;
import com.bcxin.spring.annotation.MyBatisDao;
import com.bcxin.wechat.activity.entity.ExhibitionHall;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 微信活动展责展厅
 * @apiNote  作者 陈堂君
 * @since 创建于 2018/4/10 14:05
 */
@MyBatisDao
public interface WeChatExhibitionMapper {

    /**
     * 查询活动的信息，查询活动的信息，通过活动ID进行查询
     * @apiNote  作者 陈堂君  
     * @since 创建于 2018/4/10 14:04
     * @param id 活动ID
     * @return
     */
    Map getActivityInfoById(String id);

    /**
     * 某个展厅的展位名称除重复判断，如果有记录返回，说明有重复的
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/10 16:17
     * @param exhibition_hall_id 展厅ID
     * @param posNames 展位名称集合
     * @return
     */
    List<Map> getExhibitionRepeatPosName(@Param("exhibition_hall_id") Long exhibition_hall_id, @Param("posNames")List<String> posNames);


    /**
     * 验证展位重复，一个活动下的展位是唯一的
     * @param activity_id
     * @param posNames
     * @return
     */
    List<Map> getExhibitionRepeatPos(@Param("activity_id") Long activity_id, @Param("posNames")List<String> posNames);

    /**
     * 某个展厅的除重复判断，如果有记录返回，说明有重复的
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/20 10:15
     * @param exhibition_hall_name
     * @return
     */
    List<Map> getExhibitionRepeatHallName(@Param("exhibition_hall_name") String exhibition_hall_name,@Param("activity_id") Long activity_id );

    /**
     * 如果某个展厅下有保险，那么不能删除
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/20 10:23
     * @param exhibition_hall_id
     * @return
     */
    List<Map> getInsPosCntByHall(@Param("exhibition_hall_id") Long exhibition_hall_id);

    /**
     * 删除某个展厅的展位信息
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/10 16:51
     */
    int delExhibitionPos(@Param("exhibition_hall_id") Long exhibition_hall_id, @Param("posIds")List<String> posIds);

    /**
     * 得到最近的展会活动信息
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/11 10:22
     * @param p 登录的机构ID weixin_login_company_id
     */
    List<Map> getLastActivityExhibitions(Map<Object, Object> p);

    /**
     * 得到展会的信息
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/19 15:41
     */
    List<Map> getActivityExhibitions(Map<Object, Object> p);


    /**
     * 除重复判断
     * @param id
     * @return
     */
    List<Map> getExhibitionRepeatHallNameInit(Long id);

    /**
     * 除重复判断
     * @param id
     * @return
     */
    List<Map> getExhibitionRepeatPosNameInit(Long id);
}
