package com.bcxin.wechat.account.web;

import com.bcxin.core.base.web.BaseController;
import com.bcxin.core.service.SysCompanyService;
import com.bcxin.core.service.SysUserService;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.bcxin.wechat.account.service.WXAccountService;
import com.bcxin.wechat.util.CTLUtil;
import com.bcxin.wechat.util.R;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * liyongqiang
 * 账号模块
 * 2017-8-17
 */
@Controller
@RequestMapping("${weChatPath}/account")
public class WXAccountController extends BaseController {

    @Autowired
    private WXAccountService wxAccountService;

    @Autowired
    private SysUserService sysUserService;

    @Autowired
    private SysCompanyService sysCompanyService;

    /** 我的信息 页面 */
    @RequestMapping("/index")
    public String index(@RequestParam Map<Object,Object> params, Model model, HttpServletRequest req) {
        return "wechat/account/user_info";
    }

    /** 我的信息修改 页面 */
    @RequestMapping("/upd/index")
    public String updIndex(@RequestParam Map<Object,Object> params, Model model, HttpServletRequest req) {
        return "wechat/account/user_info_upd";
    }

    /** 获得我的信息，根据session信息 */
    @RequestMapping("/getAccount")
    public @ResponseBody Object getAccount(@RequestParam Map<Object,Object> params, Model model, HttpServletRequest req) {
        Map<Object,Object> p = CTLUtil.init(req,params);
        CTLUtil.out(wxAccountService.getAccountInfo(p),getResponse());
        return null;
    }

    /** 获得我的信息，根据session信息 */
    @RequestMapping("/upd")
    public @ResponseBody Object upd(@RequestParam Map<Object,Object> params, Model model, HttpServletRequest req) {
        Map<Object,Object> p = CTLUtil.init(req,params);
        return wxAccountService.upd(p);
    }

    /** 退出登录 */
    @RequestMapping("/exit")
    public @ResponseBody Object exit(Model model, HttpServletRequest req, String code) {
        Map<Object,Object> map = (Map<Object, Object>) req.getSession().getAttribute("weixin_user");
        logger.info("退出时得到的openId: "+map.get("openId"));
        String oppenId=String.valueOf(map.get("oppenId"));
        if(StringUtils.isEmpty(oppenId)){
            oppenId="";
        }
        if(req.getSession() == null) {
            return new R(true,oppenId);
        }
        req.getSession().invalidate(); //TODO session池剔除该session

        return new R(true,oppenId);
    }





}
