/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.cache.impl;

import com.xiaoleilu.hutool.cache.GlobalPruneTimer;
import com.xiaoleilu.hutool.cache.impl.AbstractCache;
import com.xiaoleilu.hutool.cache.impl.CacheObj;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;

public class TimedCache<K, V>
extends AbstractCache<K, V> {
    private ScheduledFuture<?> pruneJobFuture;

    public TimedCache(long timeout) {
        this(timeout, new HashMap());
    }

    public TimedCache(long timeout, Map<K, CacheObj<K, V>> map) {
        this.capacity = 0;
        this.timeout = timeout;
        this.cacheMap = map;
    }

    @Override
    protected int pruneCache() {
        int count = 0;
        Iterator values = this.cacheMap.values().iterator();
        while (values.hasNext()) {
            CacheObj co = (CacheObj)values.next();
            if (!co.isExpired()) continue;
            values.remove();
            ++count;
        }
        return count;
    }

    public void schedulePrune(long delay) {
        this.pruneJobFuture = GlobalPruneTimer.INSTANCE.schedule(new Runnable(){

            @Override
            public void run() {
                TimedCache.this.prune();
            }
        }, delay);
    }

    public void cancelPruneSchedule() {
        if (null != this.pruneJobFuture) {
            this.pruneJobFuture.cancel(true);
        }
    }
}

