package com.bcxin.rest.sys.user.web;

import com.bcxin.common.constants.GlobalConstants;
import com.bcxin.common.dto.AjaxResult;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.core.entity.SysUser;
import com.bcxin.core.service.SysUserService;
import com.bcxin.core.service.SystemService;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.util.toolbox.StrUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 *
 * 用户操作接口
 * Created by playboy on 2017/5/22.
 */
@Controller
@RequestMapping("${apiPath}/webUser")
public class sysUserApiController extends BaseController {

    /**
     * 用户服务
     */
    @Autowired
    private SysUserService sysUserService;

    @Autowired
    private SystemService systemService;

    /**
     * 用户同步
     * @param sysUser
     * @return
     */
    @RequestMapping(value = "/receiveData",method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult receiveData(SysUser sysUser){
        String msg = beanValidatorAPI(sysUser);
        if(StrUtil.isNotBlank(msg)){
            return fail(false,msg);
        }
//        if(StrUtil.isNotBlank(sysUser.getEmail())){
//            if(sysUserService.selectCheckData(sysUser.getEmail(),null,null,sysUser.getId())){
//                return success(false,"邮箱已经存在");
//            }
//        }
//        if(StrUtil.isNotBlank(sysUser.getTelephone())){
//            if(sysUserService.selectCheckData(null,null,sysUser.getTelephone(),sysUser.getId())){
//                return success(false,"手机已经存在");
//            }
//        }
//        if(StrUtil.isNotBlank(sysUser.getEmail())){
//            if(sysUserService.selectCheckData(sysUser.getLoginName(),null,null,sysUser.getId())){
//                return success(false,"登录名已经存在");
//            }
//        }
//        sysUser.setLoginPassword(systemService.entryptPassword(sysUser.getLoginPassword()));
        if(null!=sysUser.getId()) {
            SysUser sysUser1 = sysUserService.selectById(sysUser.getId());
            if (sysUser1 != null) {
                sysUser.setId(sysUser1.getId());
            }else{
                return success(false,"ID不存在");
            }
        }
        sysUserService.save(sysUser);
        return new AjaxResult(true,"操作成功", sysUser.getId());

    }

    /**
     * 验证数据
     * @param
     */
    @RequestMapping(value = "/checkUser",method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult checkUser(String email,String telephone,String loginName,Long id){
        if(StrUtil.isNotBlank(email)){
            if(sysUserService.selectCheckData(email,null,null,id)){
                return success(true,"邮箱已经存在");
            }
        }
        if(StrUtil.isNotBlank(telephone)){
            if(sysUserService.selectCheckData(null,null,telephone,id)){
                return success(true,"手机已经存在");
            }
        }
        if(StrUtil.isNotBlank(loginName)){
            if(sysUserService.selectCheckData(loginName,null,null,id)){
                return success(true,"登录名已经存在");
            }
        }
        return success(false);
    }

    /**
     * 通过手机号或者邮箱或者账号修改密码
     * @param
     * @param
     * @return
     */
    @RequestMapping(value = "/edit/psw", method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult editPwd(SysUser sysUser){
        if(StrUtil.isBlank(sysUser.getLoginPassword())){
            return success(false, "修改失败!密码不能为空");
        }
        EntityWrapper entityWrapper = new EntityWrapper();
        if(StrUtil.isNotBlank(sysUser.getLoginName())){
            entityWrapper.addFilter(" login_name = {0}",sysUser.getLoginName());
        }
        if(StrUtil.isNotBlank(sysUser.getTelephone())){
            entityWrapper.addFilter(" telephone = {0}",sysUser.getTelephone());
        }
        if(StrUtil.isNotBlank(sysUser.getEmail())){
            entityWrapper.addFilter(" email = {0}",sysUser.getEmail());
        }
        SysUser sysUser1 = sysUserService.selectOne(entityWrapper);
        if(sysUser1==null){
            return success(false, "修改失败!");
        }
        sysUser1.setLoginPassword(systemService.entryptPassword(sysUser.getLoginPassword()));
        sysUserService.save(sysUser1);
        return json(true, sysUser1);
    }

    /**
     * 重置密码
     * @param userId
     * @return
     */
    @RequestMapping(value = "/repwd/{userId}",method = RequestMethod.GET)
    @ResponseBody
    public AjaxResult rePwd(@PathVariable Long userId) {
        if (userId != null) {
            SysUser sysUser = sysUserService.selectOne(new EntityWrapper().addFilter("web_user_id={0}",userId));
            sysUserService.updateUserPws(sysUser.getId(), GlobalConstants.getConfig("defaultPassWord"));
            return json(true, GlobalConstants.getConfig("defaultPassWord"));
        }else{
            return fail(false, "重置失败");
        }
    }
}
