package com.bcxin.rest.order.web;

import com.alibaba.fastjson.JSON;
import com.bcxin.common.constants.GlobalConstants;
import com.bcxin.common.dto.AjaxResult;
import com.bcxin.common.mapper.JsonMapper;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.core.service.SysCompanyService;
import com.bcxin.core.service.SysUserService;
import com.bcxin.models.order.dao.OrderFormDao;
import com.bcxin.models.order.entity.OrderForm;
import com.bcxin.models.order.entity.OrderPayment;
import com.bcxin.models.order.service.OrderCompanyRelationService;
import com.bcxin.models.order.service.OrderFormService;
import com.bcxin.models.order.service.OrderPaymentService;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.spring.http.HttpService;
import com.bcxin.util.toolbox.DateUtil;
import com.bcxin.util.toolbox.StrUtil;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 订单接口
 * Created by playboy on 2017/6/9.
 */
@Controller
@RequestMapping(value = "${apiPath}/webOrderForm")
public class OrderFormApiController extends BaseController{

    @Autowired
    private SysCompanyService sysCompanyService;
    /**
     * 订单服务
     */
    @Autowired
    private OrderFormService orderFormService;
    /**
     * 人员
     */
    @Autowired
    private SysUserService sysUserService;

    /**
     * 支付服务
     */
    @Autowired
    private OrderPaymentService orderPaymentService;

    /**
     * 订单归属服务
     */
    @Autowired
    private OrderCompanyRelationService orderCompanyRelationService;
    @Autowired
    private HttpService httpService;
    @Autowired
    private OrderFormDao orderFormDao;

    private static final Logger log = LoggerFactory.getLogger(OrderFormApiController.class);


    public static final String HXXY_GET_FEE_URL= GlobalConstants.getConfig("HXXT")+"/api/getPSSAgreement";

    /**
     * 获取PSS风评供应商产品信息
     * @param ywzcId
     * @param riskType
     * @param province
     * @param city
     * @param area
     * @return
     */
    @RequestMapping(value = "/getPSSSupplyProduct")
    @ResponseBody
    public AjaxResult getPSSSupplyProduct(String ywzcId,String riskType,String province,String city,String area){
        AjaxResult ajaxResult=new AjaxResult(true);
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("companyId", ywzcId);
            map.put("riskType", riskType);
            map.put("province", province);
            map.put("city", city);
            map.put("area", area);
            List<Map<String,Object>> list=sysCompanyService.findPSSSupplyProduct(map);
            ajaxResult.setData(list);
            return ajaxResult;
        }catch (Exception e){
            ajaxResult.setMessage(e.getMessage());
            ajaxResult.setSuccess(false);
        }
        return ajaxResult;
    }


    @RequestMapping(value = "/getFeeRate")
    @ResponseBody
    public AjaxResult getFeeRate(String ywzcId,String productId,String province,String city,String area){
        AjaxResult ajaxResult=new AjaxResult(true);
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("companyId", ywzcId);
            map.put("productId", productId);
            map.put("province", province);
            map.put("city", city);
            map.put("area", area);
            String result = httpService.doPost(HXXY_GET_FEE_URL, map);
            ajaxResult = JSON.parseObject(result,AjaxResult.class);
            return ajaxResult;
        }catch (Exception e){
            ajaxResult.setMessage(e.getMessage());
            ajaxResult.setSuccess(false);
        }
        return ajaxResult;
    }


    /**
     *专家订单接口
     *
     * @param risk_activity_id 风评活动ID
     * @param export_id 专家id
     * @param product_id 活动的产品id
     * @param project_name 项目名称
     * @return
     */
    @RequestMapping(value = "/receiveExportData",method = RequestMethod.POST)
    @ResponseBody
    @Transactional
    public AjaxResult receiveExportData(@RequestParam Long risk_activity_id,@RequestParam Long export_id,
                                        @RequestParam Long product_id,@RequestParam String project_name,@RequestParam String step){
        log.info("专家数据对接开始：------------"+export_id);
        log.info("专家数据：------------：riskActivityID:" + risk_activity_id + ",productID：" + product_id+",project_name：" + project_name+ ",export_id：" + export_id+ ",step：" + step);
         //创建虚拟专家订单
            if(!(StrUtil.isEmpty(step)||"null".equals(export_id)||"".equals(export_id))) {
                //除重操作，同一个风评活动id会有三单，然后就只有一单 活动id
                if (orderFormService.selectByRiskActivityIDAndProductID(risk_activity_id, product_id, export_id, step) < 1) {
                    log.info("专家数据查重结束，没有重复数据：------------"+export_id);

                    boolean rs = orderFormService.updataExportOrderFrom(risk_activity_id, export_id, product_id, project_name,step);
//                    /*将活动名称加入到分配订单表中*/
//                    OrderForm orderForm=orderFormService.selectOne(new EntityWrapper().addFilter("web_order_form_id={0}",risk_activity_id));
//                    orderForm.setProjectName(project_name);
//                    orderFormService.save(orderForm);

                    if (!rs) {
                        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                        return new AjaxResult(false, "不完全保存，请求失败");
                    }

                    log.info("专家数据对接结束：------------" + export_id);
                    return new AjaxResult(true, "专家订单接口操作成功");
                } else {
                    log.info("错误：订单数据重复：riskActivityID:" + risk_activity_id + ",productID：" + product_id+ ",export_id：" + export_id+ ",step：" + step);
                    return new AjaxResult(false, "订单数据重复：riskActivityID:" + risk_activity_id + ",productID：" + product_id+ ",export_id：" + export_id+ ",step：" + step);

                }
            }else {
                log.info("订单数据为空：riskActivityID:" + risk_activity_id + ",productID：" + product_id+ ",export_id：" + export_id+ ",step：" + step);
                  return new AjaxResult(false, "订单数据为空：riskActivityID:" + risk_activity_id + ",productID：" + product_id+ ",export_id：" + export_id+ ",step：" + step);
            }
    }
    /**
     * 订单同步
     * @return
     */
    @RequestMapping(value = "/receiveOrderFormData",method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult receiveOrderFormData(OrderForm orderForm ,String activity_id){
        log.info("订单同步参数DDTBCS："+ JSON.toJSONString(orderForm));
        //根据百联保订单id获得对应的活动信息！！！
        List<Map> activity = orderFormDao.getActivityInfoById(activity_id);
        if(activity.size()>0){
            orderForm.setProjectName(String.valueOf(activity.get(0).get("activity_name")));
        }
//        List<Map> blbList = orderFormDao.getActivityInfoByBlbOrderId(orderForm.getOrderNumber());
//        if(blbList.size()>0){
//            orderForm.setProjectName(String.valueOf(blbList.get(0).get("activity_name")));
//        }else{
//            List<Map> activitys = orderFormDao.getActivityInfoById(activity_id);
//            if(activitys.size()>0){
//                orderForm.setProjectName(String.valueOf(activitys.get(0).get("activity_name")));
//            }
//        }
        String msg;
        if(orderForm!=null) {
            msg = beanValidatorAPI(orderForm);
            if (StrUtil.isNotBlank(msg)) {
                return fail(false, msg);
            }
        }
        List<OrderForm> list= orderFormService.selectList(new EntityWrapper().addFilter("web_order_form_id={0} and sign={1}",orderForm.getWebOrderFormId(),orderForm.getSign()));
        if(null!=list&&list.size()>0){
            return new AjaxResult(true, "该订单已经存在!",StrUtil.obj2Str(list.get(0).getId()));
        }
        OrderPayment orderPayment = orderForm.getOrderPayment();
        //初始化订单ID,初次传入订单ID的时候订单ID为非必填,订单保存成功后重新设置订单ID
        orderPayment.setOrderFormId(0L);
        if(orderPayment!=null){
            msg = beanValidator(orderPayment);
            if (StrUtil.isNotBlank(msg)) {
                return fail(false, msg);
            }
        }else{
            return fail(false, "支付信息不能为空");
        }
        orderFormService.saveOrderFormOrPayment(orderForm,orderPayment);
        return new AjaxResult(true,"操作成功",StrUtil.obj2Str(orderForm.getId()));
    }

    /**
     * 订单支付记录
     * @return
     */
    @RequestMapping(value = "/receiveOrderPaymentData",method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult receiveOrderFormData(OrderPayment orderPayment){
        String msg ;
        if(orderPayment!=null) {
            msg = beanValidator(orderPayment);
            if (StrUtil.isNotBlank(msg)) {
                return fail(false, msg);
            }
        }
        int count = orderFormService.selectCount(new EntityWrapper(new OrderForm(orderPayment.getOrderFormId())));
        if(count<1){
            return fail(false, "该订单不存在");
        }
        orderFormService.saveOrderFormOrPayment(null,orderPayment);
        return new AjaxResult(true,"操作成功",StrUtil.obj2Str(orderPayment.getOrderFormId()));
    }

    /**
     * 订单撤单
     */
    @RequestMapping(value = "/cancellationOrder",method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult cancellationOrder(@RequestParam Long orderFormId,@RequestParam String sign){
        int count = orderFormService.selectCount(new EntityWrapper(new OrderForm(orderFormId)));
        if(count<1){
            return fail(false, "该订单不存在");
        }
        return fail(true,"撤单成功");
    }

    /**
     * 查询终端用户购买的且生效的订单列表
     */
    @RequestMapping(value = "/queryOrderFormList",method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult queryOrderFormList(@RequestParam String webUserId,@RequestParam String sign){
        OrderForm orderForm = new OrderForm();
        orderForm.setWebUserId(webUserId);
        orderForm.setSign(sign);
        List<OrderForm> list = orderFormService.selectList(new EntityWrapper(orderForm));
        return new AjaxResult(true,"操作成功",list);
    }

    /**
     * 核心系统专用接口  同步订单信息
     * @return
     */
    @RequestMapping(value = "/getOrderFormHXXT",method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult getOrderFormHXXT(String startDate){
        Map<String,Object> params = Maps.newHashMap();
        if(StrUtil.isNotBlank(startDate)){
            params.put("startDate",startDate);
        }
        List<Map<String,Object>> orderFormList = orderFormService.selectToHxxt(params);
        return json(true,StrUtil.formatDate(orderFormList));
    }

    /**
     * 核心系统专用接口  支付接口同步信息
     * @return
     */
    @RequestMapping(value = "/getOrderFormPaymentHXXT",method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult getOrderFormPaymentHXXT(String startDate){
        Map<String,Object> params = Maps.newHashMap();
        if(StrUtil.isNotBlank(startDate)) {
            params.put("startDate", startDate);
        }
        List<Map<String,Object>> orderPaymentList =orderPaymentService.selectToHxxt(params);
        return json(true,StrUtil.formatDate(StrUtil.formatDate(orderPaymentList)));
    }

    /**
     * 核心系统专用接口 订单归属同步
     * @return
     */
    @RequestMapping(value = "/getOrderFormCompanyHXXT",method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult getOrderFormCompanyHXXT(String startDate){
        Map<String,Object> params = Maps.newHashMap();
        if(StrUtil.isNotBlank(startDate)) {
            params.put("startDate", startDate);
        }
        List<Map<String,Object>> orderPaymentList =orderCompanyRelationService.selectToHxxt(params);
        return json(true,orderPaymentList);
    }



    /**
     * 专家订单同步(同步到)
     * @return
     */
    @RequestMapping(value = "/receiveOrderFormExpertData",method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult receiveOrderFormExpertData(HttpServletRequest request){
        //      param.put("orderFormData", JsonMapper.toJsonString(list));

        String data = request.getParameter("orderFormData");
        if(StrUtil.isBlank(data)){
            return fail(false,"没有接收到数据");
        }
        List<Map<String,Object>> list = (List<Map<String, Object>>) JsonMapper.fromJsonString(data,List.class);

        if(list!=null) {
            expertOrderData(list);
        }

        return new AjaxResult(true,"操作成功",list.size());
    }

    private void expertOrderData(List<Map<String,Object>> list) {

        for(Map<String,Object> o:list){
                orderCompanyRelationService.saveExpertOrder(o);
        }

    }


    @RequestMapping(value = "/test")
      public void test(){
        OrderForm orderForm=new OrderForm();
//      orderForm.setAddress("风评佣金测试");
        orderForm.setCity("350100");
        orderForm.setCurrency("CNY");
        orderForm.setDistributorId("943068372292505602L");
        orderForm.setDistrict("0");
        orderForm.setEndDate(DateUtil.parseDate("2018-12-20"));
        orderForm.setFcy(new BigDecimal("0.01"));
        orderForm.setInvoiceType("1");
        orderForm.setOrderDate(DateUtil.parseDate("2017-12-20 15:10:05"));
        orderForm.setOrderNumber("TEST2-7708120171220");
        orderForm.setProductId(871284565591744512L);//01风评产品20171106
        orderForm.setProvince("350000");
        orderForm.setSign("STS");
        orderForm.setStagesNumber("1");
        orderForm.setStartDate(DateUtil.parseDate("2017-12-20"));
        orderForm.setWebOrderFormId("TEST2-770812017122120");
        orderForm.setWebUserId("0");
        orderForm.setPaymentMethod("1");
//        orderForm.setProductType("3");

        OrderPayment  payment  = new OrderPayment();
        payment.setActualPayment(new BigDecimal("0.01"));
        payment.setCurrentPayable(new BigDecimal("0.01"));
//        payment.setPayCode("");
        payment.setPayDate(DateUtil.parseDate("2017-12-12 17:32:14"));
        payment.setPaySerialNumber("770812017121220");
        payment.setPaymentMethod(3);
//        payment.setPaymentPeriod("");
        payment.setRemainingNumber(1);
        orderForm.setOrderPayment(payment);

//        receiveOrderFormData(orderForm);

    }


}
