/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rest.sys.login.web;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.common.constants.GlobalConstants;
import com.bcxin.common.dto.AjaxResult;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.core.security.UsernamePassword;
import com.bcxin.core.service.SysUserService;
import com.bcxin.core.util.SysUserUtils;
import com.bcxin.spring.cache.CacheUtils;
import com.bcxin.spring.security.Principal;
import com.bcxin.spring.util.ServletUtils;
import com.bcxin.util.Encodes;
import com.bcxin.util.MD5Utils;
import com.bcxin.util.toolbox.DateUtil;
import com.bcxin.util.toolbox.StrUtil;
import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${apiPath}/"})
public class SysLoginApiController
extends BaseController {
    @Autowired
    private SysUserService sysUserService;

    @RequestMapping(value={"sso"})
    public String sso(HttpServletResponse response, String loginName, String bcxinToken, @RequestParam(required=true) String password, String redirectToUrl, String relogin, Model model) {
        Principal principal = SysUserUtils.getPrincipal();
        String email = this.getParameter("email");
        String phone = this.getParameter("telephone");
        String sign = this.getParameter("sign");
        if (StrUtil.isBlank((String)loginName) && StrUtil.isBlank((String)email) && StrUtil.isBlank((String)phone)) {
            return this.renderString(response, new AjaxResult(false, "\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StrUtil.isBlank((String)sign)) {
            return this.renderString(response, new AjaxResult(false, "\u5e73\u53f0\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (principal != null) {
            if (BooleanUtils.toBoolean((String)relogin)) {
                SysUserUtils.getSubject().logout();
            } else {
                return this.redirectTo(Encodes.urlDecode((String)redirectToUrl));
            }
        }
        if (StrUtil.isBlank((String)bcxinToken)) {
            String name = loginName;
            if (StrUtil.isBlank((String)loginName)) {
                name = email;
            }
            if (StrUtil.isBlank((String)loginName)) {
                name = phone;
            }
            bcxinToken = MD5Utils.string2MD5((String)(name + DateUtil.getTimestamp() + GlobalConstants.getConfig((String)"shiro.sso.secretKey")));
        }
        Subject currentUser = SecurityUtils.getSubject();
        UsernamePassword token = new UsernamePassword(loginName, password, bcxinToken);
        token.setEmail(email);
        token.setPhone(phone);
        token.setSign(sign);
        token.setRememberMe(true);
        try {
            currentUser.login((AuthenticationToken)token);
        }
        catch (UnknownAccountException e) {
            return this.renderString(response, new AjaxResult(false, "\u8be5\u8d26\u53f7\u4e0d\u5b58\u5728"));
        }
        catch (DisabledAccountException e) {
            return this.renderString(response, new AjaxResult(false, "\u8be5\u8d26\u53f7\u5df2\u88ab\u51bb\u7ed3"));
        }
        catch (IncorrectCredentialsException e) {
            return this.renderString(response, new AjaxResult(false, "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef"));
        }
        catch (AuthenticationException e) {
            return this.renderString(response, new AjaxResult(false, "\u8be5\u5df2\u5e10\u53f7\u7981\u6b62\u767b\u5f55"));
        }
        catch (RuntimeException e) {
            return this.renderString(response, new AjaxResult(false, "\u672a\u77e5\u9519\u8bef"));
        }
        CacheUtils.put((String)bcxinToken, (Object)SysUserUtils.getSession().getId());
        HashMap map = Maps.newHashMap();
        map.put("token", bcxinToken);
        map.put("user", SysUserUtils.getUser());
        this.sysUserService.updateLogByLoginName(SysUserUtils.getPrincipal().getId(), ServletUtils.getIpAddr(), ServletUtils.getUserBrowser(), ServletUtils.getUserOperatingSystem());
        return this.renderString(response, new AjaxResult(true, "\u767b\u5f55\u6210\u529f", (Object)map));
    }

    @RequestMapping(value={"/logout"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult loginOut() {
        JSONObject json = new JSONObject();
        Subject subject = SecurityUtils.getSubject();
        subject.logout();
        CacheUtils.remove((String)this.getParameter("bcxinToken"));
        return this.success(true, "\u64cd\u4f5c\u6210\u529f!!");
    }
}

