/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rest.sys.company.web;

import com.bcxin.common.dto.AjaxResult;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.core.entity.SysCompany;
import com.bcxin.core.entity.SysCompanyContacts;
import com.bcxin.core.entity.SysUser;
import com.bcxin.core.service.SysAreaRelationService;
import com.bcxin.core.service.SysCompanyContactsService;
import com.bcxin.core.service.SysCompanyService;
import com.bcxin.models.product.service.ProductRelationService;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.util.toolbox.StrUtil;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${apiPath}/webCompany"})
public class SysCompanyApiController
extends BaseController {
    @Autowired
    private SysCompanyService sysCompanyService;
    @Autowired
    private SysCompanyContactsService sysCompanyContactsService;
    @Autowired
    private ProductRelationService productRelationService;
    @Autowired
    private SysAreaRelationService sysAreaRelationService;

    @RequestMapping(value={"/receiveTerminalData"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult receiveTerminalCompany(SysCompany sysCompany) {
        String msg = this.beanValidatorAPI(sysCompany, new Class[0]);
        if (StrUtil.isNotBlank((CharSequence)msg)) {
            return this.fail(false, msg);
        }
        if (sysCompany.getCompanyType() == null) {
            sysCompany.setCompanyType(SysCompany.TERMINAL_TYPE_BUSINESS);
        }
        this.sysCompanyService.save((Object)sysCompany);
        List list = sysCompany.getContactsList();
        if (null != list && list.size() > 0 && null != sysCompany.getId()) {
            this.sysCompanyContactsService.delete(new EntityWrapper().addFilter("company_id={0}", new Object[]{sysCompany.getId()}));
            for (SysCompanyContacts sysCompanyContacts : list) {
                sysCompanyContacts.setSysCompany(sysCompany);
                this.sysCompanyContactsService.insert((Object)sysCompanyContacts);
            }
        }
        return new AjaxResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)sysCompany.getId());
    }

    @RequestMapping(value={"/querySupplierlData"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult querySupplierCompany(@RequestParam String sign, @RequestParam String type, String startDate) {
        if (StrUtil.isBlank((String)type)) {
            return this.fail(false, "\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysCompany sysCompany = new SysCompany();
        sysCompany.setCompanyType(SysCompany.COMPANY_TYPE_SUPPLIER);
        sysCompany.setEnterpriseType(type);
        sysCompany.setStartDate(startDate);
        sysCompany.setStatus(Integer.valueOf(-1));
        List companyList = this.sysCompanyService.getCompanyApiList(sysCompany);
        return this.json(true, companyList);
    }

    @RequestMapping(value={"/checkDistributorCompany"})
    @ResponseBody
    public AjaxResult checkDistributorCompany(@RequestParam String sign, @RequestParam String webUserId) {
        if (StrUtil.isBlank((String)webUserId)) {
            return this.fail(false, "\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysUser user = new SysUser();
        user.setWebUserId(webUserId);
        user.setWebType(sign);
        SysCompany company = this.sysCompanyService.getCompanyBySysUser(user);
        if (null != company && company.getId() != null && company.getCompanyType().equals(SysCompany.COMPANY_TYPE_DISTRIBUTOR)) {
            return new AjaxResult(true, "\u8be5\u7528\u6237\u662f\u5206\u9500\u5546", (Object)company.getId());
        }
        return this.fail(false, "\u8be5\u7528\u6237\u4e0d\u662f\u5206\u9500\u5546");
    }

    @RequestMapping(value={"/queryDistributorCompanyList"})
    @ResponseBody
    public AjaxResult queryDistributorCompanyList(@RequestParam String sign, @RequestParam String productId) {
        HashMap params = Maps.newHashMap();
        params.put("productId", productId);
        params.put("type", "1");
        params.put("companyType", "2");
        List companyMap = this.productRelationService.getCompanyDList((Map)params);
        return this.json(true, companyMap);
    }

    @RequestMapping(value={"/getSysCompanyHXXT"})
    @ResponseBody
    public AjaxResult getSysCompanyHXXT(Date startDate) {
        HashMap params = Maps.newHashMap();
        params.put("startDate", startDate);
        params.put("inCompanyStr", new String[]{"1", "2", "4"});
        List list = this.sysCompanyService.getCompanyListData((Map)params);
        return new AjaxResult(true, (Object)list);
    }

    @RequestMapping(value={"/getSysCompanyAreaHXXT"})
    @ResponseBody
    public AjaxResult getSysCompanyAreaHXXT(Date startDate) {
        HashMap params = Maps.newHashMap();
        params.put("startDate", startDate);
        List list = this.sysAreaRelationService.selectToHxxt((Map)params);
        return new AjaxResult(true, (Object)StrUtil.formatDate((List)list));
    }
}

