/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rest.product.web;

import com.bcxin.common.dto.AjaxResult;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.models.product.dao.ProductRelationDao;
import com.bcxin.models.product.entity.ProductType;
import com.bcxin.models.product.service.ProductRelationService;
import com.bcxin.models.product.util.ProductTypeUtil;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.util.toolbox.Str2Utils;
import com.bcxin.util.toolbox.StrUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${apiPath}/webProduct"})
public class ProductApiController
extends BaseController {
    @Autowired
    ProductRelationService productRelationService;
    @Autowired
    ProductRelationDao productRelationDao;

    @RequestMapping(value={"/getProductList"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult getProductInsList(@RequestParam String sign, String productId, String startDate, @RequestParam Integer productType) {
        HashMap params = Maps.newHashMap();
        params.put("sign", sign);
        params.put("productId", productId);
        params.put("startDate", startDate);
        params.put("productType", productType);
        List list = this.productRelationService.getProductListDetails((Map)params);
        return new AjaxResult(true, "\u8bf7\u6c42\u6210\u529f", (Object)list);
    }

    @RequestMapping(value={"/getProductListHXXT"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult getProductListHXXT(String startDate) {
        HashMap params = Maps.newHashMap();
        params.put("startDate", startDate);
        List list = this.productRelationService.selectToHxxt((Map)params);
        ArrayList rtnList = Lists.newArrayList();
        for (Map map : list) {
            ArrayList pList = Lists.newArrayList();
            ProductType.sortList((List)pList, (List)ProductTypeUtil.getProductTypeList((String)StrUtil.obj2Str(map.get("productType"))), (Long)StrUtil.toLong(map.get("typeId")));
            ArrayList tempList = Lists.newArrayList();
            for (ProductType productType : pList) {
                if (!StrUtil.isNotBlank((CharSequence)productType.getTypeLevel())) continue;
                tempList.add(productType.getTypeName());
            }
            map.put("type", Str2Utils.arrayToString((String[])Str2Utils.toStringArray((List)tempList), (String)"-"));
            rtnList.add(map);
        }
        return new AjaxResult(true, "\u8bf7\u6c42\u6210\u529f", (Object)list);
    }

    @RequestMapping(value={"/getProductRelationListHXXT"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult getProductRelationList(String startDate) {
        HashMap p = Maps.newHashMap();
        p.put("startDate", startDate);
        List res = this.productRelationDao.selectProductRelation((Map)p);
        return new AjaxResult(true, "\u8bf7\u6c42\u6210\u529f", (Object)res);
    }

    public void test(String startDate) {
        if (null != startDate) {
            List list = this.productRelationService.selectList(new EntityWrapper().addFilter("update_time>={0} and type in('1','2') and hxxt_id is null", new Object[]{startDate}));
        } else {
            List list = this.productRelationService.selectList(new EntityWrapper().addFilter("type in('1','2')  and hxxt_id is null", new Object[]{startDate}));
        }
    }
}

