/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rest.fee.web;

import com.alibaba.fastjson.JSON;
import com.bcxin.common.dto.AjaxResult;
import com.bcxin.common.mapper.JsonMapper;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.models.fee.entity.FeeSettlementMonth;
import com.bcxin.models.fee.service.IFeeSettlementMonthService;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.util.toolbox.StrUtil;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${apiPath}/webFeeMonth"})
public class FeeMonthController
extends BaseController {
    @Autowired
    private IFeeSettlementMonthService feeSettlementMonthService;

    @RequestMapping(value={"/receiveMonthData"})
    @ResponseBody
    public AjaxResult receiveFeeSettlementData(HttpServletRequest request) {
        String data = request.getParameter("monthData");
        if (StrUtil.isBlank((String)data)) {
            return this.fail(false, "\u6ca1\u6709\u63a5\u6536\u5230\u6570\u636e");
        }
        ArrayList feeMonthList = Lists.newArrayList();
        List list = (List)JsonMapper.fromJsonString((String)data, List.class);
        this.logger.info("\u63a5\u53e3\u83b7\u5f97\u7684\u6570\u636e\u5217\u8868\u662f\uff1a" + JSON.toJSONString((Object)list));
        if (list.size() > 0) {
            for (Map map : list) {
                FeeSettlementMonth f = (FeeSettlementMonth)JsonMapper.fromJsonString((String)JsonMapper.toJsonString((Object)map), FeeSettlementMonth.class);
                List l = this.feeSettlementMonthService.selectList(new EntityWrapper().addFilter("DATE_FORMAT(current_month, '%Y-%m')={0} and product_type={1} and province={2} and cooperation_id={3}", new Object[]{new SimpleDateFormat("yyyy-MM").format(f.getCurrentMonth()), f.getProductType(), f.getProvince(), f.getCooperationId()}));
                if (l.size() == 0) {
                    this.feeSettlementMonthService.insert((Object)f);
                    continue;
                }
                f.setId(((FeeSettlementMonth)l.get(0)).getId());
                this.feeSettlementMonthService.updateById((Object)f);
            }
        } else {
            return this.fail(false, "\u4fdd\u5b58\u5931\u8d25");
        }
        return this.success(true, "\u4fdd\u5b58\u6210\u529f[" + feeMonthList.size() + "]\u6761\u6570\u636e.\u4fdd\u5b58\u5931\u8d25[" + (list.size() - feeMonthList.size()) + "]\u6761\u6570\u636e");
    }
}

